/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.plugins;

import jadx.api.plugins.gui.ISettingsGroup;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsGroupPluginWrap
implements ISettingsGroup {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsGroupPluginWrap.class);
    private final String pluginId;
    private final ISettingsGroup pluginSettingGroup;

    public SettingsGroupPluginWrap(String pluginId, ISettingsGroup pluginSettingGroup) {
        this.pluginId = pluginId;
        this.pluginSettingGroup = pluginSettingGroup;
    }

    public String getTitle() {
        try {
            return this.pluginSettingGroup.getTitle();
        }
        catch (Throwable t) {
            LOG.warn("Failed to get settings group title for plugin: {}", (Object)this.pluginId, (Object)t);
            return "<error>";
        }
    }

    public JComponent buildComponent() {
        try {
            return this.pluginSettingGroup.buildComponent();
        }
        catch (Throwable t) {
            LOG.warn("Failed to build settings group component for plugin: {}", (Object)this.pluginId, (Object)t);
            return new JLabel("<error>");
        }
    }

    public List<ISettingsGroup> getSubGroups() {
        try {
            return this.pluginSettingGroup.getSubGroups();
        }
        catch (Throwable t) {
            LOG.warn("Failed to get settings group sub-groups for plugin: {}", (Object)this.pluginId, (Object)t);
            return Collections.emptyList();
        }
    }

    public void close(boolean save) {
        try {
            this.pluginSettingGroup.close(save);
        }
        catch (Throwable t) {
            LOG.warn("Failed to close settings group for plugin: {}", (Object)this.pluginId, (Object)t);
        }
    }
}

