/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.utils.JumpPosition;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JumpManager {
    private static final int MAX_JUMPS = 100;
    private static final int LIST_SHRINK_COUNT = 50;
    private final List<JumpPosition> list = new ArrayList<JumpPosition>(100);
    private int currentPos = 0;

    public void addPosition(@Nullable JumpPosition pos) {
        if (pos == null || this.ignoreJump(pos)) {
            return;
        }
        ++this.currentPos;
        if (this.currentPos >= this.list.size()) {
            this.list.add(pos);
            if (this.list.size() >= 100) {
                this.list.subList(0, 50).clear();
            }
            this.currentPos = this.list.size() - 1;
        } else {
            this.list.set(this.currentPos, pos);
            this.list.subList(this.currentPos + 1, this.list.size()).clear();
        }
    }

    public int size() {
        return this.list.size();
    }

    private boolean ignoreJump(JumpPosition pos) {
        JumpPosition current = this.getCurrent();
        if (current == null) {
            return false;
        }
        return pos.equals(current);
    }

    @Nullable
    public JumpPosition getCurrent() {
        if (this.currentPos >= 0 && this.currentPos < this.list.size()) {
            return this.list.get(this.currentPos);
        }
        return null;
    }

    @Nullable
    public JumpPosition getPrev() {
        if (this.currentPos == 0) {
            return null;
        }
        --this.currentPos;
        return this.list.get(this.currentPos);
    }

    @Nullable
    public JumpPosition getNext() {
        int size = this.list.size();
        if (size == 0) {
            this.currentPos = 0;
            return null;
        }
        int newPos = this.currentPos + 1;
        if (newPos >= size) {
            this.currentPos = size - 1;
            return null;
        }
        JumpPosition position = this.list.get(newPos);
        if (position == null) {
            return null;
        }
        this.currentPos = newPos;
        return position;
    }

    public void reset() {
        this.list.clear();
        this.currentPos = 0;
    }
}

