/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.commons.app.JadxSystemInfo;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.device.debugger.DbgUtils;
import jadx.gui.device.debugger.DebugSettings;
import jadx.gui.device.protocol.ADB;
import jadx.gui.device.protocol.ADBDevice;
import jadx.gui.device.protocol.ADBDeviceInfo;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.IDebugController;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADBDialog
extends JDialog
implements ADB.DeviceStateListener,
ADB.JDWPProcessListener {
    private static final Logger LOG = LoggerFactory.getLogger(ADBDialog.class);
    private static final long serialVersionUID = -1111111202102181630L;
    private static final ImageIcon ICON_DEVICE = UiUtils.openSvgIcon("adb/androidDevice");
    private static final ImageIcon ICON_PROCESS = UiUtils.openSvgIcon("adb/addToWatch");
    private final transient MainWindow mainWindow;
    private transient Label tipLabel;
    private transient JTextField pathTextField;
    private transient JTextField hostTextField;
    private transient JTextField portTextField;
    private transient DefaultTreeModel procTreeModel;
    private transient DefaultMutableTreeNode procTreeRoot;
    private transient JTree procTree;
    private Socket deviceSocket;
    private transient List<DeviceNode> deviceNodes = new ArrayList<DeviceNode>();
    private transient DeviceNode lastSelectedDeviceNode;

    public ADBDialog(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.initUI();
        this.pathTextField.setText(mainWindow.getSettings().getAdbDialogPath());
        this.hostTextField.setText(mainWindow.getSettings().getAdbDialogHost());
        this.portTextField.setText(mainWindow.getSettings().getAdbDialogPort());
        if (this.pathTextField.getText().isEmpty()) {
            this.detectADBPath();
        } else {
            this.pathTextField.setText("");
        }
        SwingUtilities.invokeLater(this::connectToADB);
        UiUtils.addEscapeShortCutToDispose(this);
    }

    private void initUI() {
        this.pathTextField = new JTextField();
        this.portTextField = new JTextField();
        this.hostTextField = new JTextField();
        JPanel adbPanel = new JPanel(new BorderLayout(5, 5));
        adbPanel.add((Component)new JLabel(NLS.str("adb_dialog.path")), "West");
        adbPanel.add((Component)this.pathTextField, "Center");
        JPanel portPanel = new JPanel(new BorderLayout(5, 0));
        portPanel.add((Component)new JLabel(NLS.str("adb_dialog.port")), "West");
        portPanel.add((Component)this.portTextField, "Center");
        JPanel hostPanel = new JPanel(new BorderLayout(5, 0));
        hostPanel.add((Component)new JLabel(NLS.str("adb_dialog.addr")), "West");
        hostPanel.add((Component)this.hostTextField, "Center");
        JPanel wrapperPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        wrapperPanel.add(hostPanel);
        wrapperPanel.add(portPanel);
        adbPanel.add((Component)wrapperPanel, "South");
        this.procTree = new JTree();
        JScrollPane scrollPane = new JScrollPane(this.procTree);
        scrollPane.setMinimumSize(new Dimension(100, 150));
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.procTree.getSelectionModel().setSelectionMode(1);
        this.procTreeRoot = new DefaultMutableTreeNode(NLS.str("adb_dialog.device_node"));
        this.procTreeModel = new DefaultTreeModel(this.procTreeRoot);
        this.procTree.setModel(this.procTreeModel);
        this.procTree.setRowHeight(-1);
        Font font = this.mainWindow.getSettings().getFont();
        this.procTree.setFont(font.deriveFont((float)font.getSize() + 1.0f));
        this.procTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ADBDialog.this.processSelected(e);
                }
            }
        });
        this.procTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -1111111202103170735L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DeviceTreeNode || value == ADBDialog.this.procTreeRoot) {
                    this.setIcon(ICON_DEVICE);
                } else {
                    this.setIcon(ICON_PROCESS);
                }
                return c;
            }
        });
        this.procTree.addTreeSelectionListener(event -> {
            Object selectedNode = this.procTree.getLastSelectedPathComponent();
            if (selectedNode instanceof DeviceTreeNode) {
                this.lastSelectedDeviceNode = this.deviceNodes.stream().filter(item -> item.tNode == selectedNode).findFirst().orElse(null);
            }
        });
        JPanel btnPane = new JPanel();
        BoxLayout boxLayout = new BoxLayout(btnPane, 2);
        btnPane.setLayout(boxLayout);
        this.tipLabel = new Label(NLS.str("adb_dialog.waiting"));
        btnPane.add(this.tipLabel);
        JButton refreshBtn = new JButton(NLS.str("adb_dialog.refresh"));
        JButton startServerBtn = new JButton(NLS.str("adb_dialog.start_server"));
        JButton launchAppBtn = new JButton(NLS.str("adb_dialog.launch_app"));
        btnPane.add(launchAppBtn);
        btnPane.add(startServerBtn);
        btnPane.add(refreshBtn);
        refreshBtn.addActionListener(e -> {
            this.clear();
            this.procTreeRoot.removeAllChildren();
            this.procTreeModel.reload(this.procTreeRoot);
            SwingUtilities.invokeLater(this::connectToADB);
        });
        startServerBtn.addActionListener(e -> this.startADBServer());
        launchAppBtn.addActionListener(e -> this.launchApp());
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        mainPane.add((Component)adbPanel, "North");
        mainPane.add((Component)scrollPane, "Center");
        mainPane.add((Component)btnPane, "South");
        mainPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(mainPane);
        this.pack();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
    }

    private void clear() {
        if (this.deviceSocket != null) {
            try {
                this.deviceSocket.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close device socket", (Throwable)e);
            }
            this.deviceSocket = null;
        }
        for (DeviceNode deviceNode : this.deviceNodes) {
            deviceNode.device.stopListenForJDWP();
        }
        this.deviceNodes.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void detectADBPath() {
        String[] paths;
        boolean isWinOS = JadxSystemInfo.IS_WINDOWS;
        String slash = isWinOS ? "\\" : "/";
        String adbName = isWinOS ? "adb.exe" : "adb";
        Object sdkPath = System.getenv("ANDROID_HOME");
        if (!StringUtils.isEmpty((String)sdkPath)) {
            if (!((String)sdkPath).endsWith(slash)) {
                sdkPath = (String)sdkPath + slash;
            }
            if (new File((String)(sdkPath = (String)sdkPath + "platform-tools" + slash + adbName)).exists()) {
                this.pathTextField.setText((String)sdkPath);
                return;
            }
        }
        String envPath = System.getenv("PATH");
        for (String string : paths = envPath.split(isWinOS ? ";" : ":")) {
            void var10_13;
            String string2;
            if (!string.endsWith(slash)) {
                String string3 = string + slash;
            }
            if (!new File(string2 = (String)var10_13 + adbName).exists()) continue;
            this.pathTextField.setText(string2);
            return;
        }
    }

    private void startADBServer() {
        String tip;
        String path = this.pathTextField.getText();
        if (path.isEmpty()) {
            UiUtils.showMessageBox(this.mainWindow, NLS.str("adb_dialog.missing_path"));
            return;
        }
        try {
            tip = ADB.startServer(path, Integer.parseInt(this.portTextField.getText())) ? NLS.str("adb_dialog.start_okay", this.portTextField.getText()) : NLS.str("adb_dialog.start_fail", this.portTextField.getText());
        }
        catch (Exception e) {
            LOG.error("Failed to start adb server", (Throwable)e);
            tip = e.getMessage();
        }
        UiUtils.showMessageBox(this.mainWindow, tip);
        this.tipLabel.setText(tip);
    }

    private void connectToADB() {
        String tip;
        try {
            String host = this.hostTextField.getText().trim();
            String port = this.portTextField.getText().trim();
            this.tipLabel.setText(NLS.str("adb_dialog.connecting", host, port));
            this.deviceSocket = ADB.listenForDeviceState(this, host, Integer.parseInt(port));
            if (this.deviceSocket != null) {
                tip = NLS.str("adb_dialog.connect_okay", host, port);
                this.setTitle(tip);
            } else {
                tip = NLS.str("adb_dialog.connect_fail");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to connect to adb", (Throwable)e);
            tip = e.getMessage();
            UiUtils.showMessageBox(this.mainWindow, tip);
        }
        this.tipLabel.setText(tip);
    }

    @Override
    public void onDeviceStatusChange(List<ADBDeviceInfo> deviceInfoList) {
        ArrayList<DeviceNode> nodes = new ArrayList<DeviceNode>(deviceInfoList.size());
        block0: for (ADBDeviceInfo info : deviceInfoList) {
            for (DeviceNode deviceNode : this.deviceNodes) {
                if (!deviceNode.device.updateDeviceInfo(info)) continue;
                deviceNode.refresh();
                nodes.add(deviceNode);
                continue block0;
            }
            ADBDevice device = new ADBDevice(info);
            device.getAndroidReleaseVersion();
            nodes.add(new DeviceNode(device));
            this.listenJDWP(device);
        }
        this.deviceNodes = nodes;
        SwingUtilities.invokeLater(() -> {
            this.tipLabel.setText(NLS.str("adb_dialog.tip_devices", this.deviceNodes.size()));
            this.procTreeRoot.removeAllChildren();
            this.deviceNodes.forEach(n -> this.procTreeRoot.add(n.tNode));
            this.procTreeModel.reload(this.procTreeRoot);
            for (DeviceNode deviceNode : this.deviceNodes) {
                this.procTree.expandPath(new TreePath(deviceNode.tNode.getPath()));
            }
        });
    }

    private void processSelected(MouseEvent e) {
        TreePath path = this.procTree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            String pid = this.getPid((String)node.getUserObject());
            if (StringUtils.isEmpty((String)pid)) {
                return;
            }
            if (this.mainWindow.getDebuggerPanel() != null && this.mainWindow.getDebuggerPanel().getDbgController().isDebugging()) {
                IDebugController ctrl;
                if (JOptionPane.showConfirmDialog(this.mainWindow, NLS.str("adb_dialog.restart_while_debugging_msg"), NLS.str("adb_dialog.restart_while_debugging_title"), 2) != 2 && ADBDialog.launchForDebugging(this.mainWindow, (ctrl = this.mainWindow.getDebuggerPanel().getDbgController()).getProcessName(), true)) {
                    this.dispose();
                }
                return;
            }
            DeviceNode deviceNode = this.getDeviceNode((DefaultMutableTreeNode)node.getParent());
            if (deviceNode == null) {
                return;
            }
            if (!this.setupArgs(deviceNode.device, pid, (String)node.getUserObject())) {
                return;
            }
            if (DebugSettings.INSTANCE.isBeingDebugged() && JOptionPane.showConfirmDialog(this.mainWindow, NLS.str("adb_dialog.being_debugged_msg"), NLS.str("adb_dialog.being_debugged_title"), 2) == 2) {
                return;
            }
            this.tipLabel.setText(NLS.str("adb_dialog.starting_debugger"));
            if (!ADBDialog.attachProcess(this.mainWindow)) {
                this.tipLabel.setText(NLS.str("adb_dialog.init_dbg_fail"));
            } else {
                this.dispose();
            }
        }
    }

    private static boolean attachProcess(MainWindow mainWindow) {
        DebugSettings debugSettings = DebugSettings.INSTANCE;
        debugSettings.clearForward();
        String rst = debugSettings.forwardJDWP();
        if (!rst.isEmpty()) {
            UiUtils.showMessageBox(mainWindow, rst);
            return false;
        }
        try {
            return mainWindow.getDebuggerPanel().showDebugger(debugSettings.getName(), debugSettings.getDevice().getDeviceInfo().getAdbHost(), debugSettings.getForwardTcpPort(), debugSettings.getVer(), debugSettings.getDevice(), debugSettings.getPid());
        }
        catch (Exception e) {
            LOG.error("Failed to attach to process", (Throwable)e);
            return false;
        }
    }

    public static boolean launchForDebugging(MainWindow mainWindow, String fullAppPath, boolean autoAttach) {
        DebugSettings debugSettings = DebugSettings.INSTANCE;
        debugSettings.setAutoAttachPkg(autoAttach);
        try {
            int pid = debugSettings.getDevice().launchApp(fullAppPath);
            if (pid != -1) {
                debugSettings.setPid(String.valueOf(pid)).setName(fullAppPath);
                return ADBDialog.attachProcess(mainWindow);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to launch app", (Throwable)e);
        }
        return false;
    }

    private String getPid(String nodeText) {
        int pos;
        if (nodeText.startsWith("[pid:") && (pos = nodeText.indexOf(93, "[pid:".length())) != -1) {
            return nodeText.substring("[pid:".length(), pos).trim();
        }
        return null;
    }

    private DeviceNode getDeviceNode(DefaultMutableTreeNode node) {
        for (DeviceNode deviceNode : this.deviceNodes) {
            if (deviceNode.tNode != node) continue;
            return deviceNode;
        }
        return null;
    }

    private DeviceNode getDeviceNode(ADBDevice device) {
        for (DeviceNode deviceNode : this.deviceNodes) {
            if (!deviceNode.device.equals(device)) continue;
            return deviceNode;
        }
        throw new JadxRuntimeException("Unexpected device: " + String.valueOf(device));
    }

    private void listenJDWP(ADBDevice device) {
        try {
            device.listenForJDWP(this);
        }
        catch (Exception e) {
            LOG.error("Failed listen for JDWP", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
        boolean save = this.mainWindow.getSettings().getAdbDialogPath().equals(this.pathTextField.getText());
        boolean save1 = this.mainWindow.getSettings().getAdbDialogHost().equals(this.hostTextField.getText());
        boolean save2 = this.mainWindow.getSettings().getAdbDialogPort().equals(this.portTextField.getText());
        if (save || save1 || save2) {
            this.mainWindow.getSettings().sync();
        }
    }

    @Override
    public void adbDisconnected() {
        this.deviceSocket = null;
        SwingUtilities.invokeLater(() -> {
            this.tipLabel.setText(NLS.str("adb_dialog.disconnected"));
            this.setTitle("");
        });
    }

    @Override
    public void jdwpProcessOccurred(ADBDevice device, Set<String> id) {
        DeviceNode node;
        List<ADB.Process> procs;
        try {
            Thread.sleep(40L);
            procs = device.getProcessList();
        }
        catch (Exception e) {
            LOG.error("Failed to get device process list", (Throwable)e);
            procs = Collections.emptyList();
        }
        ArrayList<String> procList = new ArrayList<String>(id.size());
        if (procs.isEmpty()) {
            procList.addAll(id);
        } else {
            for (ADB.Process proc : procs) {
                if (!id.contains(proc.pid)) continue;
                procList.add(String.format("[pid: %-6s] %s", proc.pid, proc.name));
            }
        }
        Collections.reverse(procList);
        try {
            node = this.getDeviceNode(device);
        }
        catch (Exception e) {
            LOG.error("Failed to find device", (Throwable)e);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            node.tNode.removeAllChildren();
            DefaultMutableTreeNode foundNode = null;
            DebugSettings debugSettings = DebugSettings.INSTANCE;
            for (String procStr : procList) {
                DefaultMutableTreeNode pnode = new DefaultMutableTreeNode(procStr);
                node.tNode.add(pnode);
                if (debugSettings.getExpectPkg().isEmpty() || !procStr.endsWith(debugSettings.getExpectPkg())) continue;
                if (debugSettings.isAutoAttachPkg() && debugSettings.getDevice().equals(node.device)) {
                    debugSettings.set(node.device, debugSettings.getVer(), this.getPid(procStr), procStr);
                    if (ADBDialog.attachProcess(this.mainWindow)) {
                        this.dispose();
                        return;
                    }
                }
                foundNode = pnode;
            }
            this.procTreeModel.reload(node.tNode);
            this.procTree.expandPath(new TreePath(node.tNode.getPath()));
            if (foundNode != null) {
                TreePath thePath = new TreePath(foundNode.getPath());
                this.procTree.scrollPathToVisible(thePath);
                this.procTree.setSelectionPath(thePath);
            }
        });
    }

    private void launchApp() {
        ADBDevice device;
        if (this.deviceNodes.isEmpty()) {
            UiUtils.showMessageBox(this.mainWindow, NLS.str("adb_dialog.no_devices"));
            return;
        }
        DbgUtils.AppData appData = DbgUtils.parseAppData(this.mainWindow);
        if (appData == null) {
            return;
        }
        if (this.scrollToProcNode(appData.getAppPackage())) {
            return;
        }
        String processName = appData.getProcessName();
        ADBDevice aDBDevice = device = this.lastSelectedDeviceNode == null ? this.deviceNodes.get((int)0).device : this.lastSelectedDeviceNode.device;
        if (device != null) {
            try {
                device.launchApp(processName);
            }
            catch (Exception e) {
                LOG.error("Failed to launch app: {}", (Object)processName, (Object)e);
                UiUtils.showMessageBox(this.mainWindow, e.getMessage());
            }
        }
    }

    private boolean scrollToProcNode(String pkg) {
        if (pkg.isEmpty()) {
            return false;
        }
        DebugSettings.INSTANCE.setExpectPkg(" " + pkg);
        for (int i = 0; i < this.procTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode rn = (DefaultMutableTreeNode)this.procTreeRoot.getChildAt(i);
            for (int j = 0; j < rn.getChildCount(); ++j) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)rn.getChildAt(j);
                String pName = (String)n.getUserObject();
                if (!pName.endsWith(DebugSettings.INSTANCE.getExpectPkg())) continue;
                TreePath path = new TreePath(n.getPath());
                this.procTree.scrollPathToVisible(path);
                this.procTree.setSelectionPath(path);
                return true;
            }
        }
        return false;
    }

    @Override
    public void jdwpListenerClosed(ADBDevice device) {
    }

    private boolean setupArgs(ADBDevice device, String pid, String name) {
        String ver = device.getAndroidReleaseVersion();
        if (StringUtils.isEmpty((String)ver)) {
            if (JOptionPane.showConfirmDialog(this.mainWindow, NLS.str("adb_dialog.unknown_android_ver"), "", 2) == 2) {
                return false;
            }
            ver = "8";
        }
        ver = this.getMajorVer(ver);
        DebugSettings.INSTANCE.set(device, Integer.parseInt(ver), pid, name);
        return true;
    }

    private String getMajorVer(String ver) {
        int pos = ver.indexOf(46);
        if (pos != -1) {
            ver = ver.substring(0, pos);
        }
        return ver;
    }

    private static class DeviceNode {
        ADBDevice device;
        DeviceTreeNode tNode;

        DeviceNode(ADBDevice adbDevice) {
            this.device = adbDevice;
            this.tNode = new DeviceTreeNode();
            this.refresh();
        }

        void refresh() {
            ADBDeviceInfo info = this.device.getDeviceInfo();
            Object text = info.getModel();
            if (text != null) {
                if (!((String)text).equals(info.getSerial())) {
                    text = (String)text + String.format(" [serial: %s]", info.getSerial());
                }
                text = (String)text + String.format(" [state: %s]", info.isOnline() ? "online" : "offline");
                this.tNode.setUserObject(text);
            }
        }
    }

    private static class DeviceTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1111111202103131112L;

        private DeviceTreeNode() {
        }
    }
}

