/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea.theme;

import jadx.gui.ui.codearea.theme.IEditorTheme;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSTAThemeXML
implements IEditorTheme {
    private static final Logger LOG = LoggerFactory.getLogger(RSTAThemeXML.class);
    private final Path themePath;
    private final String name;
    private Theme loadedTheme;

    public RSTAThemeXML(Path themeXmlPath, String name) {
        this.themePath = themeXmlPath;
        this.name = name;
    }

    @Override
    public String getId() {
        return "file:" + String.valueOf(this.themePath);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load() {
        try (InputStream is = Files.newInputStream(this.themePath, new OpenOption[0]);){
            this.loadedTheme = Theme.load((InputStream)is);
        }
        catch (Exception e) {
            LOG.warn("Failed to load editor theme: {}", (Object)this.themePath, (Object)e);
            this.loadedTheme = new Theme(new RSyntaxTextArea());
        }
    }

    @Override
    public void apply(RSyntaxTextArea textArea) {
        this.loadedTheme.apply(textArea);
    }

    @Override
    public void unload() {
        this.loadedTheme = null;
    }
}

