/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.core.utils.StringUtils;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.ui.codearea.SourceLineFormatter;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.utils.CaretPositionFix;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.MousePressedHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import org.fife.ui.rtextarea.LineNumberFormatter;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class CodePanel
extends JPanel {
    private static final long serialVersionUID = 1117721869391885865L;
    private final SearchBar searchBar;
    private final AbstractCodeArea codeArea;
    private final RTextScrollPane codeScrollPane;
    private boolean useSourceLines;
    private static final LineNumberFormatter SIMPLE_LINE_FORMATTER = new LineNumberFormatter(){

        public String format(int lineNumber) {
            return Integer.toString(lineNumber);
        }

        public int getMaxLength(int maxLineNumber) {
            return SourceLineFormatter.getNumberLength(maxLineNumber);
        }
    };

    public CodePanel(final AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
        this.searchBar = new SearchBar(codeArea);
        this.codeScrollPane = new RTextScrollPane((RTextArea)codeArea);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.searchBar, "North");
        this.add((Component)this.codeScrollPane, "Center");
        this.initLinesModeSwitch();
        KeyStroke key = KeyStroke.getKeyStroke(70, UiUtils.ctrlButton());
        UiUtils.addKeyBinding((JComponent)((Object)codeArea), key, "SearchAction", new AbstractAction(){
            private static final long serialVersionUID = 71338030532869694L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CodePanel.this.searchBar.showAndFocus();
            }
        });
        final JMenuItem searchItem = new JMenuItem();
        final JMenuItem globalSearchItem = new JMenuItem();
        final AbstractAction searchAction = new AbstractAction(NLS.str("popup.search", "")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodePanel.this.searchBar.toggle();
            }
        };
        final AbstractAction globalSearchAction = new AbstractAction(NLS.str("popup.search_global", "")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow mainWindow = codeArea.getContentPanel().getMainWindow();
                SearchDialog.searchText(mainWindow, codeArea.getSelectedText());
            }
        };
        searchItem.setAction(searchAction);
        globalSearchItem.setAction(globalSearchAction);
        final JPopupMenu.Separator separator = new JPopupMenu.Separator();
        final JPopupMenu popupMenu = codeArea.getPopupMenu();
        popupMenu.addPopupMenuListener(new DefaultPopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object preferText = codeArea.getSelectedText();
                if (!StringUtils.isEmpty((String)preferText)) {
                    if (((String)preferText).length() >= 23) {
                        preferText = ((String)preferText).substring(0, 20) + " ...";
                    }
                    searchAction.putValue("Name", NLS.str("popup.search", preferText));
                    globalSearchAction.putValue("Name", NLS.str("popup.search_global", preferText));
                    popupMenu.add(separator);
                    popupMenu.add(globalSearchItem);
                    popupMenu.add(searchItem);
                } else {
                    popupMenu.remove(separator);
                    popupMenu.remove(globalSearchItem);
                    popupMenu.remove(searchItem);
                }
            }
        });
    }

    public void loadSettings() {
        this.codeArea.loadSettings();
        this.initLineNumbers();
    }

    public void load() {
        this.codeArea.load();
        this.initLineNumbers();
    }

    private synchronized void initLineNumbers() {
        this.codeScrollPane.getGutter().setLineNumberFont(this.getSettings().getFont());
        LineNumbersMode mode = this.getLineNumbersMode();
        if (mode == LineNumbersMode.DISABLE) {
            this.codeScrollPane.setLineNumbersEnabled(false);
            return;
        }
        this.useSourceLines = mode == LineNumbersMode.DEBUG;
        this.applyLineFormatter();
        this.codeScrollPane.setLineNumbersEnabled(true);
    }

    private synchronized void applyLineFormatter() {
        LineNumberFormatter linesFormatter = this.useSourceLines ? new SourceLineFormatter(this.codeArea.getCodeInfo()) : SIMPLE_LINE_FORMATTER;
        this.codeScrollPane.getGutter().setLineNumberFormatter(linesFormatter);
    }

    private LineNumbersMode getLineNumbersMode() {
        LineNumbersMode mode = this.getSettings().getLineNumbersMode();
        boolean canShowDebugLines = this.canShowDebugLines();
        if (mode == LineNumbersMode.AUTO) {
            mode = canShowDebugLines ? LineNumbersMode.DEBUG : LineNumbersMode.NORMAL;
        } else if (mode == LineNumbersMode.DEBUG && !canShowDebugLines) {
            mode = LineNumbersMode.DISABLE;
        }
        return mode;
    }

    private boolean canShowDebugLines() {
        if (this.codeArea instanceof SmaliArea) {
            return false;
        }
        ICodeInfo codeInfo = this.codeArea.getCodeInfo();
        if (!codeInfo.hasMetadata()) {
            return false;
        }
        Map lineMapping = codeInfo.getCodeMetadata().getLineMapping();
        if (lineMapping.isEmpty()) {
            return false;
        }
        HashSet uniqueDebugLines = new HashSet(lineMapping.values());
        return uniqueDebugLines.size() > 3;
    }

    private void initLinesModeSwitch() {
        MousePressedHandler lineModeSwitch = new MousePressedHandler(ev -> {
            this.useSourceLines = !this.useSourceLines;
            this.applyLineFormatter();
        });
        for (Component gutterComp : this.codeScrollPane.getGutter().getComponents()) {
            if (!(gutterComp instanceof LineNumberList)) continue;
            gutterComp.addMouseListener(lineModeSwitch);
        }
    }

    public SearchBar getSearchBar() {
        return this.searchBar;
    }

    public AbstractCodeArea getCodeArea() {
        return this.codeArea;
    }

    public JScrollPane getCodeScrollPane() {
        return this.codeScrollPane;
    }

    public void refresh(CaretPositionFix caretFix) {
        JViewport viewport = this.getCodeScrollPane().getViewport();
        Point viewPosition = viewport.getViewPosition();
        this.codeArea.refresh();
        this.initLineNumbers();
        SwingUtilities.invokeLater(() -> {
            viewport.setViewPosition(viewPosition);
            caretFix.restore();
        });
    }

    private JadxSettings getSettings() {
        return this.codeArea.getContentPanel().getTabbedPane().getMainWindow().getSettings();
    }

    public void dispose() {
        this.codeArea.dispose();
    }
}

