/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.gui.JadxWrapper;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.action.CommentSearchAction;
import jadx.gui.ui.action.FindUsageAction;
import jadx.gui.ui.action.FridaAction;
import jadx.gui.ui.action.GoToDeclarationAction;
import jadx.gui.ui.action.JsonPrettifyAction;
import jadx.gui.ui.action.RenameAction;
import jadx.gui.ui.action.XposedAction;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.ui.codearea.CommentAction;
import jadx.gui.ui.codearea.JNodePopupBuilder;
import jadx.gui.ui.codearea.JadxTokenMaker;
import jadx.gui.ui.codearea.MouseHoverHighlighter;
import jadx.gui.ui.codearea.UsageDialogPlusAction;
import jadx.gui.ui.codearea.mode.JCodeMode;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.CaretPositionFix;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.ShortcutsController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(CodeArea.class);
    private static final long serialVersionUID = 6312736869579635796L;
    @Nullable
    private ICodeInfo cachedCodeInfo;
    @Nullable
    private MouseHoverHighlighter mouseHoverHighlighter;
    private final ShortcutsController shortcutsController = this.getMainWindow().getShortcutsController();

    CodeArea(ContentPanel contentPanel, JNode node) {
        super(contentPanel, node);
        this.setSyntaxEditingStyle(node.getSyntaxName());
        boolean isJavaCode = this.isCodeNode();
        if (isJavaCode) {
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle((TokenMaker)new JadxTokenMaker(this));
        }
        if (node instanceof JResource && node.makeString().endsWith(".json")) {
            this.addMenuForJsonFile();
        }
        this.setHyperlinksEnabled(true);
        this.setCodeFoldingEnabled(true);
        this.setLinkScanningMask(128);
        CodeLinkGenerator codeLinkGenerator = new CodeLinkGenerator(this);
        this.setLinkGenerator(codeLinkGenerator);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isControlDown() || CodeArea.this.jumpOnDoubleClick(e)) {
                    CodeArea.this.navToDecl(e.getPoint());
                }
            }
        });
        if (isJavaCode) {
            this.mouseHoverHighlighter = new MouseHoverHighlighter(this, codeLinkGenerator);
            this.addMouseMotionListener(this.mouseHoverHighlighter);
        }
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        if (this.mouseHoverHighlighter != null) {
            this.mouseHoverHighlighter.loadSettings();
        }
    }

    public boolean isCodeNode() {
        return this.node instanceof JClass || this.node instanceof JCodeMode;
    }

    private boolean jumpOnDoubleClick(MouseEvent e) {
        return e.getClickCount() == 2 && this.getMainWindow().getSettings().isJumpOnDoubleClick();
    }

    private void navToDecl(Point point) {
        int offs = this.viewToModel2D(point);
        JNode node = this.getJNodeAtOffset(this.adjustOffsetForWordToken(offs));
        if (node != null) {
            this.contentPanel.getTabsController().codeJump(node);
        }
    }

    @Override
    public ICodeInfo getCodeInfo() {
        if (this.cachedCodeInfo == null) {
            if (this.isDisposed()) {
                LOG.debug("CodeArea used after dispose!");
                return ICodeInfo.EMPTY;
            }
            this.cachedCodeInfo = Objects.requireNonNull(this.node.getCodeInfo());
        }
        return this.cachedCodeInfo;
    }

    @Override
    public void load() {
        if (this.getText().isEmpty()) {
            this.setText(this.getCodeInfo().getCodeStr());
            this.setCaretPosition(0);
            this.setLoaded();
        }
    }

    @Override
    public void refresh() {
        this.cachedCodeInfo = null;
        this.setText(this.getCodeInfo().getCodeStr());
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = super.createPopupMenu();
        if (this.node instanceof JClass) {
            this.appendCodeMenuItems(popup);
        }
        return popup;
    }

    private void appendCodeMenuItems(JPopupMenu popupMenu) {
        ShortcutsController shortcutsController = this.getMainWindow().getShortcutsController();
        JNodePopupBuilder popup = new JNodePopupBuilder(this, popupMenu, shortcutsController);
        popup.addSeparator();
        popup.add(new FindUsageAction(this));
        popup.add(new UsageDialogPlusAction(this));
        popup.add(new GoToDeclarationAction(this));
        popup.add(new CommentAction(this));
        popup.add(new CommentSearchAction(this));
        popup.add(new RenameAction(this));
        popup.addSeparator();
        popup.add(new FridaAction(this));
        popup.add(new XposedAction(this));
        this.getMainWindow().getWrapper().getGuiPluginsContext().appendPopupMenus(this, popup);
        popupMenu.addPopupMenuListener(new DefaultPopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int offset;
                CodeArea codeArea = CodeArea.this;
                if (codeArea.getSelectedText() == null && (offset = UiUtils.getOffsetAtMousePosition(codeArea)) >= 0) {
                    codeArea.setCaretPosition(offset);
                }
            }
        });
    }

    private void addMenuForJsonFile() {
        ShortcutsController shortcutsController = this.getMainWindow().getShortcutsController();
        JNodePopupBuilder popup = new JNodePopupBuilder(this, this.getPopupMenu(), shortcutsController);
        popup.addSeparator();
        popup.add(new JsonPrettifyAction(this));
    }

    public int adjustOffsetForWordToken(int offset) {
        Token token = this.getWordTokenAtOffset(offset);
        if (token == null) {
            return -1;
        }
        int type = token.getType();
        if (this.isCodeNode()) {
            if (type == 20 || type == 8) {
                return token.getOffset();
            }
            if (type == 19 && token.length() > 1) {
                return token.getOffset() + 1;
            }
            if (type == 6 && token.length() == 6 && token.getLexeme().equals("static")) {
                return token.getOffset();
            }
        } else if (type == 28) {
            return token.getOffset() + 1;
        }
        return -1;
    }

    @Nullable
    public JumpPosition getDefPosForNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        JavaNode foundNode = this.getJavaNodeAtOffset(offset);
        if (foundNode == null) {
            return null;
        }
        if (foundNode == this.node.getJavaNode()) {
            return new JumpPosition(this.node);
        }
        JNode jNode = this.convertJavaNode(foundNode);
        return new JumpPosition(jNode);
    }

    private JNode convertJavaNode(JavaNode javaNode) {
        JNodeCache nodeCache = this.getMainWindow().getCacheObject().getNodeCache();
        return nodeCache.makeFrom(javaNode);
    }

    @Nullable
    public JNode getNodeUnderCaret() {
        int caretPos = this.getCaretPosition();
        return this.getJNodeAtOffset(this.adjustOffsetForWordToken(caretPos));
    }

    @Nullable
    public JNode getEnclosingNodeUnderCaret() {
        int caretPos = this.getCaretPosition();
        int start = this.adjustOffsetForWordToken(caretPos);
        if (start == -1) {
            start = caretPos;
        }
        return this.getEnclosingJNodeAtOffset(start);
    }

    @Nullable
    public JNode getNodeUnderMouse() {
        Point pos = UiUtils.getMousePosition((Component)((Object)this));
        return this.getJNodeAtOffset(this.adjustOffsetForWordToken(this.viewToModel2D(pos)));
    }

    @Nullable
    public JNode getEnclosingNodeUnderMouse() {
        Point pos = UiUtils.getMousePosition((Component)((Object)this));
        return this.getEnclosingJNodeAtOffset(this.adjustOffsetForWordToken(this.viewToModel2D(pos)));
    }

    @Nullable
    public JNode getEnclosingJNodeAtOffset(int offset) {
        JavaNode javaNode = this.getEnclosingJavaNode(offset);
        if (javaNode != null) {
            return this.convertJavaNode(javaNode);
        }
        return null;
    }

    @Nullable
    public JNode getJNodeAtOffset(int offset) {
        JavaNode javaNode = this.getJavaNodeAtOffset(offset);
        if (javaNode != null) {
            return this.convertJavaNode(javaNode);
        }
        return null;
    }

    public JavaNode getJavaNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        try {
            return this.getJadxWrapper().getDecompiler().getJavaNodeAtPosition(this.getCodeInfo(), offset);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    public JavaNode getClosestJavaNode(int offset) {
        if (offset == -1) {
            return null;
        }
        try {
            return this.getJadxWrapper().getDecompiler().getClosestJavaNode(this.getCodeInfo(), offset);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    public JavaNode getEnclosingJavaNode(int offset) {
        if (offset == -1) {
            return null;
        }
        try {
            return this.getJadxWrapper().getDecompiler().getEnclosingNode(this.getCodeInfo(), offset);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    @Nullable
    public JavaClass getJavaClassIfAtPos(int pos) {
        try {
            ICodeInfo codeInfo = this.getCodeInfo();
            if (!codeInfo.hasMetadata()) {
                return null;
            }
            ICodeAnnotation ann = codeInfo.getCodeMetadata().getAt(pos);
            if (ann == null) {
                return null;
            }
            switch (ann.getAnnType()) {
                case CLASS: {
                    return (JavaClass)this.getJadxWrapper().getDecompiler().getJavaNodeByCodeAnnotation(codeInfo, ann);
                }
                case METHOD: {
                    JavaNode node = this.getJadxWrapper().getDecompiler().getJavaNodeByCodeAnnotation(codeInfo, ann);
                    return node != null ? node.getDeclaringClass() : null;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)pos, (Object)e);
            return null;
        }
    }

    public void refreshClass() {
        if (this.node instanceof JClass) {
            JClass cls = this.node.getRootClass();
            try {
                CaretPositionFix caretFix = new CaretPositionFix(this);
                caretFix.save();
                this.cachedCodeInfo = cls.reload(this.getMainWindow().getCacheObject());
                ClassCodeContentPanel codeContentPanel = (ClassCodeContentPanel)this.contentPanel;
                codeContentPanel.getTabbedPane().refresh(cls);
                codeContentPanel.getJavaCodePanel().refresh(caretFix);
            }
            catch (Exception e) {
                LOG.error("Failed to reload class: {}", (Object)cls.getFullName(), (Object)e);
            }
        }
    }

    public MainWindow getMainWindow() {
        return this.contentPanel.getMainWindow();
    }

    public JadxWrapper getJadxWrapper() {
        return this.getMainWindow().getWrapper();
    }

    public JadxProject getProject() {
        return this.getMainWindow().getProject();
    }

    @Override
    public void dispose() {
        this.shortcutsController.unbindActionsForComponent((JComponent)((Object)this));
        super.dispose();
        this.cachedCodeInfo = null;
    }
}

