/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.cellrenders;

import jadx.api.JavaMethod;
import jadx.gui.ui.cellrenders.MethodRenderHelper;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class MethodsListRenderer
extends JPanel
implements ListCellRenderer<JavaMethod> {
    private final JCheckBox checkBox;
    private final JLabel label;

    public MethodsListRenderer() {
        this.setLayout(new BorderLayout(5, 0));
        this.checkBox = new JCheckBox();
        this.label = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.add((Component)this.checkBox, "West");
        this.add((Component)this.label, "Center");
        this.setOpaque(true);
        this.checkBox.setOpaque(false);
        this.label.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends JavaMethod> list, JavaMethod value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setText(UiUtils.typeFormatHtml(MethodRenderHelper.makeBaseString(value), value.getReturnType()));
        this.label.setIcon(MethodRenderHelper.getIcon(value));
        this.checkBox.setSelected(isSelected);
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.label.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        return this;
    }
}

