/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.action;

import jadx.gui.ui.action.ActionCategory;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.Shortcut;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;

public enum ActionModel {
    ABOUT(ActionCategory.MENU_TOOLBAR, "menu.about", "menu.about", "ui/showInfos", Shortcut.keyboard(112)),
    OPEN(ActionCategory.MENU_TOOLBAR, "file.open_action", "file.open_action", "ui/openDisk", Shortcut.keyboard(79, 128)),
    OPEN_PROJECT(ActionCategory.MENU_TOOLBAR, "file.open_project", "file.open_project", "ui/projectDirectory", Shortcut.keyboard(79, 0x40 | UiUtils.ctrlButton())),
    ADD_FILES(ActionCategory.MENU_TOOLBAR, "file.add_files_action", "file.add_files_action", "ui/addFile", Shortcut.none()),
    NEW_PROJECT(ActionCategory.MENU_TOOLBAR, "file.new_project", "file.new_project", "ui/newFolder", Shortcut.none()),
    SAVE_PROJECT(ActionCategory.MENU_TOOLBAR, "file.save_project", "file.save_project", null, Shortcut.none()),
    SAVE_PROJECT_AS(ActionCategory.MENU_TOOLBAR, "file.save_project_as", "file.save_project_as", null, Shortcut.none()),
    RELOAD(ActionCategory.MENU_TOOLBAR, "file.reload", "file.reload", "ui/refresh", Shortcut.keyboard(116)),
    LIVE_RELOAD(ActionCategory.MENU_TOOLBAR, "file.live_reload", "file.live_reload_desc", null, Shortcut.keyboard(116, 64)),
    SAVE_ALL(ActionCategory.MENU_TOOLBAR, "file.save_all", "file.save_all", "ui/menu-saveall", Shortcut.keyboard(69, UiUtils.ctrlButton())),
    EXPORT(ActionCategory.MENU_TOOLBAR, "file.export", "file.export", "ui/export", Shortcut.keyboard(69, UiUtils.ctrlButton() | 0x40)),
    PREFS(ActionCategory.MENU_TOOLBAR, "menu.preferences", "menu.preferences", "ui/settings", Shortcut.keyboard(80, UiUtils.ctrlButton() | 0x40)),
    EXIT(ActionCategory.MENU_TOOLBAR, "file.exit", "file.exit", "ui/exit", Shortcut.none()),
    SYNC(ActionCategory.MENU_TOOLBAR, "menu.sync", "menu.sync", "ui/locate", Shortcut.keyboard(84, UiUtils.ctrlButton())),
    TEXT_SEARCH(ActionCategory.MENU_TOOLBAR, "menu.text_search", "menu.text_search", "ui/find", Shortcut.keyboard(70, UiUtils.ctrlButton() | 0x40)),
    CLASS_SEARCH(ActionCategory.MENU_TOOLBAR, "menu.class_search", "menu.class_search", "ui/ejbFinderMethod", Shortcut.keyboard(78, UiUtils.ctrlButton())),
    COMMENT_SEARCH(ActionCategory.MENU_TOOLBAR, "menu.comment_search", "menu.comment_search", "ui/usagesFinder", Shortcut.keyboard(59, UiUtils.ctrlButton() | 0x40)),
    GO_TO_MAIN_ACTIVITY(ActionCategory.MENU_TOOLBAR, "menu.go_to_main_activity", "menu.go_to_main_activity", "ui/home", Shortcut.keyboard(77, UiUtils.ctrlButton() | 0x40)),
    GO_TO_APPLICATION(ActionCategory.MENU_TOOLBAR, "menu.go_to_application", "menu.go_to_application", "ui/application", Shortcut.keyboard(65, UiUtils.ctrlButton() | 0x40)),
    GO_TO_ANDROID_MANIFEST(ActionCategory.MENU_TOOLBAR, "menu.go_to_android_manifest", "menu.go_to_android_manifest", "ui/androidManifest", Shortcut.none()),
    PREVIEW_TAB(ActionCategory.MENU_TOOLBAR, "menu.enable_preview_tab", "menu.enable_preview_tab", "ui/editorPreview", Shortcut.none()),
    DECOMPILE_ALL(ActionCategory.MENU_TOOLBAR, "menu.decompile_all", "menu.decompile_all", "ui/runAll", Shortcut.none()),
    RESET_CACHE(ActionCategory.MENU_TOOLBAR, "menu.reset_cache", "menu.reset_cache", "ui/reset", Shortcut.none()),
    DEOBF(ActionCategory.MENU_TOOLBAR, "menu.deobfuscation", "preferences.deobfuscation", "ui/helmChartLock", Shortcut.keyboard(68, UiUtils.ctrlButton() | 0x200)),
    SHOW_LOG(ActionCategory.MENU_TOOLBAR, "menu.log", "menu.log", "ui/logVerbose", Shortcut.keyboard(76, UiUtils.ctrlButton() | 0x40)),
    CREATE_DESKTOP_ENTRY(ActionCategory.MENU_TOOLBAR, "menu.create_desktop_entry", "menu.create_desktop_entry", null, Shortcut.none()),
    BACK(ActionCategory.MENU_TOOLBAR, "nav.back", "nav.back", "ui/left", Shortcut.keyboard(27)),
    BACK_V(ActionCategory.MENU_TOOLBAR, "nav.back", "nav.back", "ui/left", Shortcut.none()),
    FORWARD(ActionCategory.MENU_TOOLBAR, "nav.forward", "nav.forward", "ui/right", Shortcut.keyboard(39, 512)),
    FORWARD_V(ActionCategory.MENU_TOOLBAR, "nav.forward", "nav.forward", "ui/right", Shortcut.none()),
    QUARK(ActionCategory.MENU_TOOLBAR, "menu.quark", "menu.quark", "ui/quark", Shortcut.none()),
    OPEN_DEVICE(ActionCategory.MENU_TOOLBAR, "debugger.process_selector", "debugger.process_selector", "ui/startDebugger", Shortcut.none()),
    FIND_USAGE(ActionCategory.CODE_AREA, "popup.find_usage", "popup.find_usage", null, Shortcut.keyboard(88)),
    FIND_USAGE_PLUS(ActionCategory.CODE_AREA, "popup.usage_dialog_plus", "popup.usage_dialog_plus", null, Shortcut.keyboard(67)),
    GOTO_DECLARATION(ActionCategory.CODE_AREA, "popup.go_to_declaration", "popup.go_to_declaration", null, Shortcut.keyboard(68)),
    CODE_COMMENT(ActionCategory.CODE_AREA, "popup.add_comment", "popup.add_comment", null, Shortcut.keyboard(59)),
    CODE_COMMENT_SEARCH(ActionCategory.CODE_AREA, "popup.search_comment", "popup.search_comment", null, Shortcut.keyboard(59, UiUtils.ctrlButton())),
    CODE_RENAME(ActionCategory.CODE_AREA, "popup.rename", "popup.rename", null, Shortcut.keyboard(78)),
    FRIDA_COPY(ActionCategory.CODE_AREA, "popup.frida", "popup.frida", null, Shortcut.keyboard(70)),
    XPOSED_COPY(ActionCategory.CODE_AREA, "popup.xposed", "popup.xposed", null, Shortcut.keyboard(89)),
    JSON_PRETTIFY(ActionCategory.CODE_AREA, "popup.json_prettify", "popup.json_prettify", null, Shortcut.none()),
    SCRIPT_RUN(ActionCategory.PLUGIN_SCRIPT, "script.run", "script.run", "ui/run", Shortcut.keyboard(119)),
    SCRIPT_SAVE(ActionCategory.PLUGIN_SCRIPT, "script.save", "script.save", "ui/menu-saveall", Shortcut.keyboard(83, UiUtils.ctrlButton())),
    SCRIPT_AUTO_COMPLETE(ActionCategory.PLUGIN_SCRIPT, "script.auto_complete", "script.auto_complete", null, Shortcut.keyboard(32, UiUtils.ctrlButton())),
    HEX_VIEWER_SHOW_INSPECTOR(ActionCategory.HEX_VIEWER_MENU, "hex_viewer.show_inspector", "hex_viewer.show_inspector", null, Shortcut.none()),
    HEX_VIEWER_CHANGE_ENCODING(ActionCategory.HEX_VIEWER_MENU, "hex_viewer.change_encoding", "hex_viewer.change_encoding", null, Shortcut.none()),
    HEX_VIEWER_GO_TO_ADDRESS(ActionCategory.HEX_VIEWER_MENU, "hex_viewer.goto_address", "hex_viewer.goto_address", null, Shortcut.keyboard(74, UiUtils.ctrlButton())),
    HEX_VIEWER_FIND(ActionCategory.HEX_VIEWER_MENU, "hex_viewer.find", "hex_viewer.find", null, Shortcut.keyboard(70, UiUtils.ctrlButton()));

    private final ActionCategory category;
    private final String nameRes;
    private final String descRes;
    private final String iconPath;
    private final Shortcut defaultShortcut;

    private ActionModel(ActionCategory category, String nameRes, String descRes, String iconPath, Shortcut defaultShortcut) {
        this.category = category;
        this.nameRes = nameRes;
        this.descRes = descRes;
        this.iconPath = iconPath;
        this.defaultShortcut = defaultShortcut;
    }

    public static List<ActionModel> select(ActionCategory category) {
        return Arrays.stream(ActionModel.values()).filter(actionModel -> actionModel.category == category).collect(Collectors.toUnmodifiableList());
    }

    public ActionCategory getCategory() {
        return this.category;
    }

    public String getName() {
        if (this.nameRes != null) {
            String name = NLS.str(this.nameRes);
            if (this.name().endsWith("_V")) {
                name = NLS.str("action.variant", name);
            }
            return name;
        }
        return null;
    }

    public String getDescription() {
        if (this.descRes != null) {
            return NLS.str(this.descRes);
        }
        return null;
    }

    public ImageIcon getIcon() {
        if (this.iconPath != null) {
            return UiUtils.openSvgIcon(this.iconPath);
        }
        return null;
    }

    public Shortcut getDefaultShortcut() {
        return this.defaultShortcut;
    }
}

