/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.quark;

import com.beust.jcommander.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.utils.Utils;
import jadx.gui.JadxWrapper;
import jadx.gui.plugins.quark.QuarkReportData;
import jadx.gui.plugins.quark.QuarkReportNode;
import jadx.gui.treemodel.JMethod;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkReportPanel
extends ContentPanel {
    private static final long serialVersionUID = -242266836695889206L;
    private static final Logger LOG = LoggerFactory.getLogger(QuarkReportPanel.class);
    private final QuarkReportData data;
    private final JNodeCache nodeCache;
    private JEditorPane header;
    private JTree tree;
    private DefaultMutableTreeNode treeRoot;
    private Font font;
    private Font boldFont;
    private CachingTreeCellRenderer cellRenderer;

    protected QuarkReportPanel(TabbedPane panel, QuarkReportNode node, QuarkReportData data) {
        super(panel, node);
        this.data = data;
        this.nodeCache = panel.getMainWindow().getCacheObject().getNodeCache();
        this.prepareData();
        this.initUI();
        this.loadSettings();
    }

    private void prepareData() {
        this.data.crimes.sort(Comparator.comparingInt(c -> -c.parseConfidence()));
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.header = new JEditorPane();
        this.header.setContentType("text/html");
        this.header.setEditable(false);
        this.header.setText(this.buildHeader());
        this.cellRenderer = new CachingTreeCellRenderer();
        this.treeRoot = new TextTreeNode("Potential Malicious Activities:").bold();
        this.tree = this.buildTree();
        for (QuarkReportData.Crime crime : this.data.crimes) {
            this.treeRoot.add(new CrimeTreeNode(crime));
        }
        this.tree.expandRow(0);
        this.tree.expandRow(1);
        JScrollPane tableScroll = new JScrollPane(this.tree);
        tableScroll.setVerticalScrollBarPolicy(20);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.header, "First");
        mainPanel.add((Component)tableScroll, "Center");
        this.add(mainPanel);
    }

    private JTree buildTree() {
        final JTree tree = new JTree(this.treeRoot);
        tree.setLayout(new BorderLayout());
        tree.setBorder(BorderFactory.createEmptyBorder());
        tree.setShowsRootHandles(false);
        tree.setScrollsOnExpand(false);
        tree.setSelectionModel(null);
        tree.setCellRenderer(this.cellRenderer);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object node;
                if (SwingUtilities.isLeftMouseButton(event) && (node = QuarkReportPanel.getNodeUnderMouse(tree, event)) instanceof MethodTreeNode) {
                    JMethod method = ((MethodTreeNode)node).getJMethod();
                    QuarkReportPanel.this.tabbedPane.getTabsController().codeJump(method);
                }
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object leaf = path.getLastPathComponent();
                if (leaf instanceof CrimeTreeNode) {
                    CrimeTreeNode node = (CrimeTreeNode)leaf;
                    Enumeration<TreeNode> children = node.children();
                    while (children.hasMoreElements()) {
                        TreeNode child = children.nextElement();
                        tree.expandPath(path.pathByAddingChild(child));
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        return tree;
    }

    private String buildHeader() {
        StringEscapeUtils.Builder builder = StringEscapeUtils.builder((CharSequenceTranslator)StringEscapeUtils.ESCAPE_HTML4);
        builder.append("<h1>Quark Analysis Report</h1>");
        builder.append("<h3>");
        builder.append("File: ").append(this.data.apk_filename);
        builder.append("<br>");
        builder.append("Treat level: ").append(this.data.threat_level);
        builder.append("<br>");
        builder.append("Total score: ").append(Integer.toString(this.data.total_score));
        builder.append("</h3>");
        return builder.toString();
    }

    @Override
    public void loadSettings() {
        Font settingsFont = this.getMainWindow().getSettings().getFont();
        this.font = settingsFont.deriveFont(settingsFont.getSize2D() + 1.0f);
        this.boldFont = this.font.deriveFont(1);
        this.header.setFont(this.font);
        this.tree.setFont(this.font);
        this.cellRenderer.clearCache();
    }

    private static Object getNodeUnderMouse(JTree tree, MouseEvent mouseEvent) {
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        return path != null ? path.getLastPathComponent() : null;
    }

    public MutableTreeNode resolveMethod(String descr) {
        try {
            String[] parts = QuarkReportPanel.removeQuotes(descr).split(" ", 3);
            String cls = Utils.cleanObjectName((String)parts[0].replace('$', '.'));
            String mth = parts[1] + parts[2].replace(" ", "");
            MainWindow mainWindow = this.getMainWindow();
            JadxWrapper wrapper = mainWindow.getWrapper();
            JavaClass javaClass = wrapper.searchJavaClassByRawName(cls);
            if (javaClass == null) {
                return new TextTreeNode(cls + "." + mth);
            }
            JavaMethod javaMethod = javaClass.searchMethodByShortId(mth);
            if (javaMethod == null) {
                return new TextTreeNode(javaClass.getFullName() + "." + mth);
            }
            return new MethodTreeNode(javaMethod);
        }
        catch (Exception e) {
            LOG.error("Failed to parse method descriptor string: {}", (Object)descr, (Object)e);
            return new TextTreeNode(descr);
        }
    }

    private static String removeQuotes(String descr) {
        if (descr.charAt(0) == '\'') {
            return descr.substring(1, descr.length() - 1);
        }
        return descr;
    }

    private class MethodTreeNode
    extends BaseTreeNode {
        private static final long serialVersionUID = 4350343915220068508L;
        private final JavaMethod mth;
        private final JMethod jnode;

        public MethodTreeNode(JavaMethod mth) {
            super(mth);
            this.mth = mth;
            this.jnode = (JMethod)QuarkReportPanel.this.nodeCache.makeFrom((JavaNode)mth);
        }

        public JMethod getJMethod() {
            return this.jnode;
        }

        @Override
        public Component render() {
            NodeLabel label = new NodeLabel(this.mth.toString());
            label.setFont(QuarkReportPanel.this.font);
            label.setIcon(this.jnode.getIcon());
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return label;
        }
    }

    private class CrimeTreeNode
    extends TextTreeNode {
        private static final long serialVersionUID = -1464310215237483911L;
        private final QuarkReportData.Crime crime;

        public CrimeTreeNode(QuarkReportData.Crime crime) {
            super(crime.crime);
            this.crime = crime;
            this.bold();
            this.addDetails();
        }

        private void addDetails() {
            TextTreeNode node;
            List<JsonElement> combination;
            this.add(new TextTreeNode("Confidence: " + this.crime.confidence));
            if (Utils.notEmpty(this.crime.permissions)) {
                this.add(new TextTreeNode("Permissions: " + Strings.join((String)", ", this.crime.permissions)));
            }
            if (Utils.notEmpty(this.crime.native_api)) {
                TextTreeNode node2 = new TextTreeNode("Native API");
                for (QuarkReportData.Method method : this.crime.native_api) {
                    node2.add(new TextTreeNode(method.toString()));
                }
                this.add(node2);
            }
            if (Utils.notEmpty(combination = this.crime.combination) && combination.get(0) instanceof JsonArray) {
                node = new TextTreeNode("Combination");
                int size = combination.size();
                for (int i = 0; i < size; ++i) {
                    TextTreeNode set = new TextTreeNode("Set " + i);
                    JsonArray array = (JsonArray)combination.get(i);
                    for (JsonElement ele : array) {
                        String mth = ele.getAsString();
                        set.add(QuarkReportPanel.this.resolveMethod(mth));
                    }
                    node.add(set);
                }
                this.add(node);
            }
            if (Utils.notEmpty(this.crime.register)) {
                node = new TextTreeNode("Invocations");
                for (Map<String, QuarkReportData.InvokePlace> invokeMap : this.crime.register) {
                    invokeMap.forEach((key, value) -> node.add(QuarkReportPanel.this.resolveMethod((String)key)));
                }
                this.add(node);
            }
        }

        @Override
        public String toString() {
            return this.crime.crime;
        }
    }

    private class TextTreeNode
    extends BaseTreeNode {
        private static final long serialVersionUID = 6763410122501083453L;
        private boolean bold;

        public TextTreeNode(String text) {
            super(text);
        }

        public TextTreeNode bold() {
            this.bold = true;
            return this;
        }

        @Override
        public Component render() {
            NodeLabel label = new NodeLabel((String)this.getUserObject());
            label.setFont(this.bold ? QuarkReportPanel.this.boldFont : QuarkReportPanel.this.font);
            label.setIcon(null);
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return label;
        }
    }

    private static abstract class BaseTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 7197501219150495889L;

        public BaseTreeNode(Object userObject) {
            super(userObject);
        }

        public abstract Component render();
    }

    private static class CachingTreeCellRenderer
    implements TreeCellRenderer {
        private final Map<BaseTreeNode, Component> cache = new IdentityHashMap<BaseTreeNode, Component>();

        private CachingTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tr, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
            return this.cache.computeIfAbsent((BaseTreeNode)value, BaseTreeNode::render);
        }

        public void clearCache() {
            this.cache.clear();
        }
    }
}

