/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.ICodeCache;
import jadx.api.JavaClass;
import jadx.api.utils.tasks.ITaskExecutor;
import jadx.commons.app.JadxCommonEnv;
import jadx.core.utils.tasks.TaskExecutor;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.CancelableBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ProcessResult;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompileTask
extends CancelableBackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(DecompileTask.class);
    private static final int CLS_LIMIT = JadxCommonEnv.getInt((String)"JADX_CLS_PROCESS_LIMIT", (int)50);
    private final MainWindow mainWindow;
    private final JadxWrapper wrapper;
    private final AtomicInteger complete = new AtomicInteger(0);
    private int expectedCompleteCount;
    private ProcessResult result;

    public static int calcDecompileTimeLimit(int classCount) {
        return classCount * CLS_LIMIT + 5000;
    }

    public DecompileTask(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.wrapper = mainWindow.getWrapper();
    }

    @Override
    public String getTitle() {
        return NLS.str("progress.decompile");
    }

    @Override
    public ITaskExecutor scheduleTasks() {
        TaskExecutor executor = new TaskExecutor();
        executor.addParallelTasks(this.scheduleJobs());
        return executor;
    }

    public List<Runnable> scheduleJobs() {
        List<List<JavaClass>> batches;
        if (this.mainWindow.getCacheObject().isFullDecompilationFinished()) {
            return Collections.emptyList();
        }
        List<JavaClass> classes = this.wrapper.getIncludedClasses();
        this.expectedCompleteCount = classes.size();
        this.complete.set(0);
        try {
            batches = this.wrapper.buildDecompileBatches(classes);
        }
        catch (Exception e) {
            LOG.error("Decompile batches build error", (Throwable)e);
            return Collections.emptyList();
        }
        return this.getJobs(batches);
    }

    private List<Runnable> getJobs(List<List<JavaClass>> batches) {
        ICodeCache codeCache = this.wrapper.getArgs().getCodeCache();
        ArrayList<Runnable> jobs = new ArrayList<Runnable>(batches.size());
        for (List<JavaClass> batch : batches) {
            jobs.add(() -> {
                for (JavaClass cls : batch) {
                    if (this.isCanceled()) {
                        return;
                    }
                    try {
                        if (codeCache.contains(cls.getRawName())) continue;
                        cls.decompile();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to decompile class: {}", (Object)cls, (Object)e);
                    }
                    finally {
                        this.complete.incrementAndGet();
                    }
                }
            });
        }
        return jobs;
    }

    @Override
    public void onDone(ITaskInfo taskInfo) {
        long taskTime = taskInfo.getTime();
        long avgPerCls = taskTime / (long)Math.max(this.expectedCompleteCount, 1);
        int timeLimit = this.timeLimit();
        int skippedCls = this.expectedCompleteCount - this.complete.get();
        if (LOG.isInfoEnabled()) {
            LOG.info("Decompile and index task complete in " + taskTime + " ms (avg " + avgPerCls + " ms per class), classes: " + this.expectedCompleteCount + ", skipped: " + skippedCls + ", time limit:{ total: " + timeLimit + "ms, per cls: " + CLS_LIMIT + "ms }, status: " + String.valueOf((Object)taskInfo.getStatus()));
        }
        this.result = new ProcessResult(skippedCls, taskInfo.getStatus(), timeLimit);
        this.wrapper.unloadClasses();
        this.processDecompilationResults();
        System.gc();
        this.mainWindow.getCacheObject().setFullDecompilationFinished(skippedCls == 0);
    }

    private void processDecompilationResults() {
        int skippedCls = this.result.getSkipped();
        if (skippedCls == 0) {
            return;
        }
        TaskStatus status = this.result.getStatus();
        LOG.warn("Decompile and indexing of some classes skipped: {}, status: {}", (Object)skippedCls, (Object)status);
        switch (status) {
            case CANCEL_BY_USER: {
                String reason = NLS.str("message.userCancelTask");
                String message = NLS.str("message.indexIncomplete", reason, skippedCls);
                JOptionPane.showMessageDialog(this.mainWindow, message);
                break;
            }
            case CANCEL_BY_TIMEOUT: {
                String reason = NLS.str("message.taskTimeout", this.result.getTimeLimit());
                String message = NLS.str("message.indexIncomplete", reason, skippedCls);
                JOptionPane.showMessageDialog(this.mainWindow, message);
                break;
            }
            case CANCEL_BY_MEMORY: {
                this.mainWindow.showHeapUsageBar();
                JOptionPane.showMessageDialog(this.mainWindow, NLS.str("message.indexingClassesSkipped", skippedCls));
            }
        }
    }

    @Override
    public boolean canBeCanceled() {
        return true;
    }

    @Override
    public int timeLimit() {
        return DecompileTask.calcDecompileTimeLimit(this.expectedCompleteCount);
    }

    @Override
    public boolean checkMemoryUsage() {
        return true;
    }

    public ProcessResult getResult() {
        return this.result;
    }
}

