/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.startpage;

import jadx.gui.ui.startpage.RecentProjectItem;
import jadx.gui.ui.startpage.StartPagePanel;
import jadx.gui.utils.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class RecentProjectListCellRenderer
extends JPanel
implements ListCellRenderer<RecentProjectItem> {
    private static final long serialVersionUID = 5550591869239586857L;
    private final JLabel fileNameLabel;
    private final JLabel pathLabel;
    private final JButton removeProjectBtn;
    private final Color defaultBackground;
    private final Color defaultForeground;
    private final Color selectedBackground;
    private final Color selectedForeground;
    private Rectangle removeIconBounds;

    public RecentProjectListCellRenderer(Font baseFont) {
        super(new BorderLayout(5, 0));
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setFont(baseFont.deriveFont(1, baseFont.getSize()));
        this.pathLabel = new JLabel();
        this.pathLabel.setFont(baseFont.deriveFont((float)baseFont.getSize() - 2.0f));
        this.pathLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setOpaque(false);
        textPanel.add((Component)this.fileNameLabel, "North");
        textPanel.add((Component)this.pathLabel, "South");
        this.removeProjectBtn = new JButton();
        this.removeProjectBtn.setIcon(Icons.CLOSE_INACTIVE);
        this.removeProjectBtn.setOpaque(false);
        this.removeProjectBtn.setUI(new BasicButtonUI());
        this.removeProjectBtn.setContentAreaFilled(false);
        this.removeProjectBtn.setFocusable(false);
        this.removeProjectBtn.setBorder(null);
        this.removeProjectBtn.setBorderPainted(false);
        this.add((Component)textPanel, "Center");
        this.add((Component)this.removeProjectBtn, "East");
        this.defaultBackground = UIManager.getColor("List.background");
        this.defaultForeground = UIManager.getColor("List.foreground");
        this.selectedBackground = UIManager.getColor("List.selectionBackground");
        this.selectedForeground = UIManager.getColor("List.selectionForeground");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends RecentProjectItem> list, RecentProjectItem value, int index, boolean isSelected, boolean cellHasFocus) {
        this.fileNameLabel.setText(value.getProjectName());
        this.pathLabel.setText(value.getAbsolutePath());
        boolean isThisRemoveButtonHovered = index == StartPagePanel.hoveredRemoveBtnIndex;
        this.removeProjectBtn.setIcon(isThisRemoveButtonHovered ? Icons.CLOSE : Icons.CLOSE_INACTIVE);
        this.removeProjectBtn.setRolloverEnabled(isThisRemoveButtonHovered);
        if (isSelected) {
            this.setBackground(this.selectedBackground);
            this.fileNameLabel.setForeground(this.selectedForeground);
            this.pathLabel.setForeground(this.selectedForeground.darker());
            this.removeProjectBtn.setForeground(this.selectedForeground);
        } else {
            this.setBackground(this.defaultBackground);
            this.fileNameLabel.setForeground(this.defaultForeground);
            this.pathLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
            this.removeProjectBtn.setForeground(this.defaultForeground);
        }
        this.setToolTipText(value.getAbsolutePath());
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.removeProjectBtn.doLayout();
        int x = this.getWidth() - this.removeProjectBtn.getWidth() - this.getBorder().getBorderInsets((Component)this).right;
        int y = (this.getHeight() - this.removeProjectBtn.getHeight()) / 2;
        this.removeIconBounds = new Rectangle(x, y, this.removeProjectBtn.getWidth(), this.removeProjectBtn.getHeight());
    }

    public Rectangle getRemoveIconBounds() {
        return this.removeIconBounds;
    }
}

