/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer.search;

import jadx.gui.ui.hexviewer.HexSearchBar;
import jadx.gui.ui.hexviewer.search.SearchCondition;
import jadx.gui.ui.hexviewer.search.SearchParameters;
import jadx.gui.ui.hexviewer.search.service.BinarySearchService;
import jadx.gui.utils.NLS;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.auxiliary.binary_data.array.ByteArrayEditableData;

public class BinarySearch {
    private static final int DEFAULT_DELAY = 500;
    private InvokeSearchThread invokeSearchThread;
    private SearchThread searchThread;
    private SearchOperation currentSearchOperation = SearchOperation.FIND;
    private SearchParameters.SearchDirection currentSearchDirection = SearchParameters.SearchDirection.FORWARD;
    private final SearchParameters currentSearchParameters = new SearchParameters();
    private BinarySearchService.FoundMatches foundMatches = new BinarySearchService.FoundMatches();
    private BinarySearchService binarySearchService;
    private final BinarySearchService.SearchStatusListener searchStatusListener;
    private HexSearchBar binarySearchPanel;

    public BinarySearch(final HexSearchBar binarySearchPanel) {
        this.binarySearchPanel = binarySearchPanel;
        this.searchStatusListener = new BinarySearchService.SearchStatusListener(){

            @Override
            public void setStatus(BinarySearchService.FoundMatches foundMatches, SearchParameters.MatchMode matchMode) {
                BinarySearch.this.foundMatches = foundMatches;
                switch (foundMatches.getMatchesCount()) {
                    case 0: {
                        binarySearchPanel.setInfoLabel(NLS.str("search.match_not_found"));
                        break;
                    }
                    case 1: {
                        binarySearchPanel.setInfoLabel(matchMode == SearchParameters.MatchMode.MULTIPLE ? NLS.str("search.single_match") : NLS.str("search.match_found"));
                        break;
                    }
                    default: {
                        binarySearchPanel.setInfoLabel(String.format(NLS.str("search.match_of"), foundMatches.getMatchPosition() + 1, foundMatches.getMatchesCount()));
                    }
                }
                this.updateMatchStatus();
            }

            @Override
            public void clearStatus() {
                binarySearchPanel.setInfoLabel("");
                BinarySearch.this.foundMatches = new BinarySearchService.FoundMatches();
                this.updateMatchStatus();
            }

            private void updateMatchStatus() {
                int matchesCount = BinarySearch.this.foundMatches.getMatchesCount();
                int matchPosition = BinarySearch.this.foundMatches.getMatchPosition();
                binarySearchPanel.updateMatchCount(matchesCount > 0, matchesCount > 1 && matchPosition > 0, matchPosition < matchesCount - 1);
            }
        };
        binarySearchPanel.setControl(new HexSearchBar.Control(){

            @Override
            public void prevMatch() {
                BinarySearch.this.foundMatches.prev();
                BinarySearch.this.binarySearchService.setMatchPosition(BinarySearch.this.foundMatches.getMatchPosition());
                BinarySearch.this.searchStatusListener.setStatus(BinarySearch.this.foundMatches, BinarySearch.this.binarySearchService.getLastSearchParameters().getMatchMode());
            }

            @Override
            public void nextMatch() {
                BinarySearch.this.foundMatches.next();
                BinarySearch.this.binarySearchService.setMatchPosition(BinarySearch.this.foundMatches.getMatchPosition());
                BinarySearch.this.searchStatusListener.setStatus(BinarySearch.this.foundMatches, BinarySearch.this.binarySearchService.getLastSearchParameters().getMatchMode());
            }

            @Override
            public void performEscape() {
                BinarySearch.this.cancelSearch();
                this.close();
                BinarySearch.this.clearSearch();
            }

            @Override
            public void performFind() {
                BinarySearch.this.invokeSearch(SearchOperation.FIND);
            }

            @Override
            public void notifySearchChanged() {
                if (BinarySearch.this.currentSearchOperation == SearchOperation.FIND) {
                    BinarySearch.this.invokeSearch(SearchOperation.FIND);
                }
            }

            @Override
            public void notifySearchChanging() {
                if (BinarySearch.this.currentSearchOperation != SearchOperation.FIND) {
                    return;
                }
                SearchCondition condition = BinarySearch.this.currentSearchParameters.getCondition();
                SearchCondition updatedSearchCondition = binarySearchPanel.getSearchParameters().getCondition();
                switch (updatedSearchCondition.getSearchMode()) {
                    case TEXT: {
                        String searchText = updatedSearchCondition.getSearchText();
                        if (searchText.isEmpty()) {
                            condition.setSearchText(searchText);
                            BinarySearch.this.clearSearch();
                            return;
                        }
                        if (searchText.equals(condition.getSearchText())) {
                            return;
                        }
                        condition.setSearchText(searchText);
                        break;
                    }
                    case BINARY: {
                        EditableBinaryData searchData = (EditableBinaryData)updatedSearchCondition.getBinaryData();
                        if (searchData == null || searchData.isEmpty()) {
                            condition.setBinaryData(null);
                            BinarySearch.this.clearSearch();
                            return;
                        }
                        if (searchData.equals(condition.getBinaryData())) {
                            return;
                        }
                        ByteArrayEditableData data = new ByteArrayEditableData();
                        data.insert(0L, (BinaryData)searchData);
                        condition.setBinaryData((EditableBinaryData)data);
                        break;
                    }
                }
                BinarySearch.this.invokeSearch(SearchOperation.FIND, 500);
            }

            @Override
            public SearchParameters.SearchDirection getSearchDirection() {
                return BinarySearch.this.currentSearchDirection;
            }

            @Override
            public void close() {
                BinarySearch.this.cancelSearch();
                BinarySearch.this.clearSearch();
            }
        });
    }

    public void setBinarySearchService(BinarySearchService binarySearchService) {
        this.binarySearchService = binarySearchService;
    }

    public void setTargetComponent(HexSearchBar targetComponent) {
        this.binarySearchPanel = targetComponent;
    }

    public BinarySearchService.SearchStatusListener getSearchStatusListener() {
        return this.searchStatusListener;
    }

    private void invokeSearch(SearchOperation searchOperation) {
        this.invokeSearch(searchOperation, this.binarySearchPanel.getSearchParameters(), 0);
    }

    private void invokeSearch(SearchOperation searchOperation, int delay) {
        this.invokeSearch(searchOperation, this.binarySearchPanel.getSearchParameters(), delay);
    }

    private void invokeSearch(SearchOperation searchOperation, SearchParameters searchParameters) {
        this.invokeSearch(searchOperation, searchParameters, 0);
    }

    private void invokeSearch(SearchOperation searchOperation, SearchParameters searchParameters, int delay) {
        if (this.invokeSearchThread != null) {
            this.invokeSearchThread.interrupt();
        }
        this.invokeSearchThread = new InvokeSearchThread();
        this.invokeSearchThread.delay = delay;
        this.currentSearchOperation = searchOperation;
        this.currentSearchParameters.setFromParameters(searchParameters);
        this.invokeSearchThread.start();
    }

    public void cancelSearch() {
        if (this.invokeSearchThread != null) {
            this.invokeSearchThread.interrupt();
        }
        if (this.searchThread != null) {
            this.searchThread.interrupt();
        }
    }

    public void clearSearch() {
        SearchCondition condition = this.currentSearchParameters.getCondition();
        condition.clear();
        this.binarySearchPanel.clearSearch();
        this.binarySearchService.clearMatches();
        this.searchStatusListener.clearStatus();
    }

    public HexSearchBar getPanel() {
        return this.binarySearchPanel;
    }

    public void dataChanged() {
        this.binarySearchService.clearMatches();
        this.invokeSearch(this.currentSearchOperation, 500);
    }

    private static enum SearchOperation {
        FIND,
        FIND_AGAIN;

    }

    private class SearchThread
    extends Thread {
        public SearchThread() {
            super("SearchThread");
        }

        @Override
        public void run() {
            switch (BinarySearch.this.currentSearchOperation) {
                case FIND: {
                    BinarySearch.this.binarySearchService.performFind(BinarySearch.this.currentSearchParameters, BinarySearch.this.searchStatusListener);
                    break;
                }
                case FIND_AGAIN: {
                    BinarySearch.this.binarySearchService.performFindAgain(BinarySearch.this.searchStatusListener);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
        }
    }

    private class InvokeSearchThread
    extends Thread {
        private int delay;

        public InvokeSearchThread() {
            super("InvokeSearchThread");
            this.delay = 500;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                if (BinarySearch.this.searchThread != null) {
                    BinarySearch.this.searchThread.interrupt();
                }
                BinarySearch.this.searchThread = new SearchThread();
                BinarySearch.this.searchThread.start();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

