/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.plugins.script.ScriptContentPanel;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JEditableNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.SimpleMenuItem;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JInputScript
extends JEditableNode {
    private static final Logger LOG = LoggerFactory.getLogger(JInputScript.class);
    private static final ImageIcon SCRIPT_ICON = UiUtils.openSvgIcon("nodes/kotlin_script");
    private final Path scriptPath;
    private final String name;

    public JInputScript(Path scriptPath) {
        this.scriptPath = scriptPath;
        this.name = scriptPath.getFileName().toString().replace(".jadx.kts", "");
    }

    @Override
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return new ScriptContentPanel(tabbedPane, this);
    }

    @Override
    @NotNull
    public ICodeInfo getCodeInfo() {
        try {
            return new SimpleCodeInfo(FileUtils.readFile((Path)this.scriptPath));
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to read script file: " + this.scriptPath.toAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void save(String newContent) {
        try {
            FileUtils.writeFile((Path)this.scriptPath, (String)newContent);
            LOG.debug("Script saved: {}", (Object)this.scriptPath.toAbsolutePath());
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to write script file: " + this.scriptPath.toAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SimpleMenuItem(NLS.str("popup.add_scripts"), mainWindow::addFiles));
        menu.add(new SimpleMenuItem(NLS.str("popup.new_script"), mainWindow::addNewScript));
        menu.add(new SimpleMenuItem(NLS.str("popup.remove"), () -> mainWindow.removeInput(this.scriptPath)));
        menu.add(new SimpleMenuItem(NLS.str("popup.rename"), () -> mainWindow.renameInput(this.scriptPath)));
        return menu;
    }

    @Override
    public String getSyntaxName() {
        return "text/kotlin";
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public Icon getIcon() {
        return SCRIPT_ICON;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String makeString() {
        return this.name;
    }

    @Override
    public String getTooltip() {
        return this.scriptPath.normalize().toAbsolutePath().toString();
    }
}

