/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui;

import jadx.api.plugins.gui.ISettingsGroup;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.ui.JadxSettingsWindow;
import jadx.gui.settings.ui.SettingsTreeNode;
import jadx.gui.utils.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class SettingsTree
extends JTree {
    private final JadxSettingsWindow settingsWindow;

    public SettingsTree(JadxSettingsWindow settingsWindow) {
        this.settingsWindow = settingsWindow;
    }

    public void init(List<ISettingsGroup> groups) {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode(NLS.str("preferences.title"));
        SettingsTree.addGroups(treeRoot, groups);
        this.setModel(new DefaultTreeModel(treeRoot));
        this.getSelectionModel().setSelectionMode(1);
        this.setFocusable(false);
        this.addTreeSelectionListener(ev -> this.switchGroup());
        SettingsTree.setNodeExpandedState(this, treeRoot, true);
        this.addTreeWillExpandListener(new DisableRootCollapseListener(treeRoot));
        this.addSelectionRow(1);
    }

    private static void addGroups(DefaultMutableTreeNode base, List<ISettingsGroup> groups) {
        for (ISettingsGroup group : groups) {
            SettingsTreeNode node = new SettingsTreeNode(group);
            base.add(node);
            SettingsTree.addGroups(node, group.getSubGroups());
        }
    }

    public void selectGroup(ISettingsGroup group) {
        SettingsTreeNode node = this.searchTreeNode(group);
        if (node == null) {
            throw new JadxRuntimeException("Settings group not found: " + group);
        }
        this.setSelectionPath(new TreePath(node.getPath()));
    }

    @Nullable
    private SettingsTreeNode searchTreeNode(ISettingsGroup group) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            SettingsTreeNode node = (SettingsTreeNode)enumeration.nextElement();
            if (node.getGroup() != group) continue;
            return node;
        }
        return null;
    }

    private void switchGroup() {
        Object selected = this.getLastSelectedPathComponent();
        if (selected instanceof SettingsTreeNode) {
            ISettingsGroup group = ((SettingsTreeNode)selected).getGroup();
            this.settingsWindow.activateGroup(group);
        } else {
            this.settingsWindow.activateGroup(null);
        }
    }

    private static void setNodeExpandedState(JTree tree, TreeNode node, boolean expanded) {
        ArrayList<? extends TreeNode> list = Collections.list(node.children());
        for (TreeNode treeNode : list) {
            SettingsTree.setNodeExpandedState(tree, treeNode, expanded);
        }
        DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)node;
        if (!expanded && mutableTreeNode.isRoot()) {
            return;
        }
        TreePath treePath = new TreePath(mutableTreeNode.getPath());
        if (expanded) {
            tree.expandPath(treePath);
        } else {
            tree.collapsePath(treePath);
        }
    }

    private static class DisableRootCollapseListener
    implements TreeWillExpandListener {
        private final DefaultMutableTreeNode treeRoot;

        public DisableRootCollapseListener(DefaultMutableTreeNode treeRoot) {
            this.treeRoot = treeRoot;
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            Object current = event.getPath().getLastPathComponent();
            if (Objects.equals(current, this.treeRoot)) {
                throw new ExpandVetoException(event, "Root collapsing not allowed");
            }
        }
    }
}

