/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.plugins;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.cli.plugins.JadxFilesGetter;
import jadx.core.plugins.AppContext;
import jadx.core.plugins.JadxPluginManager;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.gui.ui.MainWindow;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class CollectPlugins {
    private final MainWindow mainWindow;

    public CollectPlugins(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public List<PluginContext> build() {
        TreeSet allPlugins = new TreeSet();
        this.mainWindow.getWrapper().getCurrentDecompiler().ifPresent(decompiler -> allPlugins.addAll(decompiler.getPluginManager().getResolvedPluginContexts()));
        JadxArgs jadxArgs = this.mainWindow.getSettings().toJadxArgs();
        try (JadxDecompiler decompiler2 = new JadxDecompiler(jadxArgs);){
            JadxPluginManager pluginManager = decompiler2.getPluginManager();
            pluginManager.registerAddPluginListener(pluginContext -> {
                AppContext appContext = new AppContext();
                appContext.setGuiContext(null);
                appContext.setFilesGetter((IJadxFilesGetter)JadxFilesGetter.INSTANCE);
                pluginContext.setAppContext(appContext);
            });
            pluginManager.load((JadxPluginLoader)new JadxExternalPluginsLoader());
            TreeSet<PluginContext> missingPlugins = new TreeSet<PluginContext>();
            for (PluginContext context : pluginManager.getAllPluginContexts()) {
                if (allPlugins.contains(context)) continue;
                missingPlugins.add(context);
            }
            if (!missingPlugins.isEmpty()) {
                pluginManager.init(missingPlugins);
                allPlugins.addAll(missingPlugins);
            }
        }
        return new ArrayList<PluginContext>(allPlugins);
    }
}

