/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.JumpPosition;
import org.jetbrains.annotations.Nullable;

public class NavigationController
implements ITabStatesListener {
    private final transient MainWindow mainWindow;
    private final transient JumpManager jumps = new JumpManager();

    public NavigationController(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        mainWindow.getTabsController().addListener(this);
    }

    public void navBack() {
        if (this.jumps.size() > 1) {
            this.jumps.updateCurPosition(this.mainWindow.getTabbedPane().getCurrentPosition());
        }
        this.jump(this.jumps.getPrev());
    }

    public void navForward() {
        if (this.jumps.size() > 1) {
            this.jumps.updateCurPosition(this.mainWindow.getTabbedPane().getCurrentPosition());
        }
        this.jump(this.jumps.getNext());
    }

    private void jump(@Nullable JumpPosition pos) {
        if (pos != null) {
            this.mainWindow.getTabsController().codeJump(pos);
        }
    }

    @Override
    public void onTabCodeJump(TabBlueprint blueprint, JumpPosition position) {
        if (position.equals(this.jumps.getCurrent())) {
            return;
        }
        this.saveCurrentPosition();
        this.jumps.addPosition(position);
    }

    @Override
    public void onTabSmaliJump(TabBlueprint blueprint, int pos, boolean debugMode) {
        this.saveCurrentPosition();
    }

    private void saveCurrentPosition() {
        JumpPosition curPos = this.mainWindow.getTabbedPane().getCurrentPosition();
        if (curPos != null) {
            this.jumps.addPosition(curPos);
        }
    }

    public void reset() {
        this.jumps.reset();
    }

    public void dispose() {
        this.reset();
        this.mainWindow.getTabsController().removeListener(this);
    }
}

