/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.data.CommentStyle;
import jadx.api.data.ICodeComment;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeData;
import jadx.gui.settings.JadxProject;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentDialog
extends JDialog {
    private static final long serialVersionUID = -1865682124935757528L;
    private static final Logger LOG = LoggerFactory.getLogger(CommentDialog.class);
    private final transient CodeArea codeArea;
    private final transient ICodeComment comment;
    private final transient boolean updateComment;
    private transient JTextArea commentArea;
    private transient JComboBox<CommentStyle> styleCombo;

    public static void show(CodeArea codeArea, ICodeComment blankComment) {
        ICodeComment existComment = CommentDialog.searchForExistComment(codeArea, blankComment);
        CommentDialog dialog = existComment != null ? new CommentDialog(codeArea, existComment, true) : new CommentDialog(codeArea, blankComment, false);
        dialog.setVisible(true);
    }

    private static void updateCommentsData(CodeArea codeArea, Consumer<List<ICodeComment>> updater) {
        try {
            JadxProject project = codeArea.getProject();
            JadxCodeData codeData = project.getCodeData();
            if (codeData == null) {
                codeData = new JadxCodeData();
            }
            ArrayList list = new ArrayList(codeData.getComments());
            updater.accept(list);
            Collections.sort(list);
            codeData.setComments(list);
            project.setCodeData(codeData);
            codeArea.getMainWindow().getWrapper().reloadCodeData();
        }
        catch (Exception e) {
            LOG.error("Comment action failed", (Throwable)e);
        }
        try {
            codeArea.refreshClass();
        }
        catch (Exception e) {
            LOG.error("Failed to reload code", (Throwable)e);
        }
    }

    private static ICodeComment searchForExistComment(CodeArea codeArea, ICodeComment blankComment) {
        try {
            JadxProject project = codeArea.getProject();
            JadxCodeData codeData = project.getCodeData();
            if (codeData == null || codeData.getComments().isEmpty()) {
                return null;
            }
            for (ICodeComment comment : codeData.getComments()) {
                if (!Objects.equals(comment.getNodeRef(), blankComment.getNodeRef()) || !Objects.equals(comment.getCodeRef(), blankComment.getCodeRef())) continue;
                return comment;
            }
        }
        catch (Exception e) {
            LOG.error("Error searching for exists comment", (Throwable)e);
        }
        return null;
    }

    public CommentDialog(CodeArea codeArea, ICodeComment comment, boolean updateComment) {
        super(codeArea.getMainWindow());
        this.codeArea = codeArea;
        this.comment = comment;
        this.updateComment = updateComment;
        this.initUI();
    }

    private void apply() {
        String newCommentStr = this.commentArea.getText().trim();
        if (newCommentStr.isEmpty()) {
            if (this.updateComment) {
                this.remove();
            } else {
                this.cancel();
            }
            return;
        }
        CommentStyle style = (CommentStyle)this.styleCombo.getSelectedItem();
        JadxCodeComment newComment = new JadxCodeComment(this.comment.getNodeRef(), this.comment.getCodeRef(), newCommentStr, style);
        if (this.updateComment) {
            CommentDialog.updateCommentsData(this.codeArea, arg_0 -> this.lambda$apply$0((ICodeComment)newComment, arg_0));
        } else {
            CommentDialog.updateCommentsData(this.codeArea, arg_0 -> CommentDialog.lambda$apply$1((ICodeComment)newComment, arg_0));
        }
        this.dispose();
    }

    private void remove() {
        CommentDialog.updateCommentsData(this.codeArea, list -> list.removeIf(c -> c == this.comment));
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    private void initUI() {
        this.commentArea = new JTextArea();
        TextStandardActions.attach(this.commentArea);
        this.commentArea.setEditable(true);
        this.commentArea.setFont(this.codeArea.getMainWindow().getSettings().getFont());
        this.commentArea.setAlignmentX(0.0f);
        this.commentArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (e.isShiftDown() || e.isControlDown()) {
                            CommentDialog.this.commentArea.append("\n");
                            break;
                        }
                        CommentDialog.this.apply();
                        break;
                    }
                    case 27: {
                        CommentDialog.this.cancel();
                    }
                }
            }
        });
        if (this.updateComment) {
            this.commentArea.setText(this.comment.getComment());
        }
        JScrollPane textAreaScrollPane = new JScrollPane(this.commentArea);
        textAreaScrollPane.setAlignmentX(0.0f);
        this.styleCombo = new JComboBox<CommentStyle>(CommentStyle.values());
        this.styleCombo.setSelectedItem(this.comment.getStyle());
        JLabel commentLabel = new JLabel(NLS.str("comment_dialog.label"), 2);
        JLabel styleLabel = new JLabel(NLS.str("comment_dialog.style"), 2);
        JLabel usageLabel = new JLabel(NLS.str("comment_dialog.usage"), 2);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 3));
        inputPanel.add(commentLabel);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(textAreaScrollPane);
        inputPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        inputPanel.add(usageLabel);
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new BoxLayout(stylePanel, 2));
        stylePanel.setAlignmentX(0.0f);
        stylePanel.add(styleLabel);
        stylePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        stylePanel.add(this.styleCombo);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.add((Component)inputPanel, "Center");
        mainPanel.add((Component)stylePanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        if (this.updateComment) {
            this.setTitle(NLS.str("comment_dialog.title.update"));
        } else {
            this.setTitle(NLS.str("comment_dialog.title.add"));
        }
        this.pack();
        if (!this.codeArea.getMainWindow().getSettings().loadWindowPos(this)) {
            this.setSize(800, 140);
        }
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        UiUtils.addEscapeShortCutToDispose(this);
    }

    protected JPanel initButtonsPanel() {
        JButton removeBtn;
        JButton cancelButton = new JButton(NLS.str("common_dialog.cancel"));
        cancelButton.addActionListener(event -> this.cancel());
        String applyStr = this.updateComment ? NLS.str("common_dialog.update") : NLS.str("common_dialog.add");
        JButton renameBtn = new JButton(applyStr);
        renameBtn.addActionListener(event -> this.apply());
        this.getRootPane().setDefaultButton(renameBtn);
        if (this.updateComment) {
            removeBtn = new JButton(NLS.str("common_dialog.remove"));
            removeBtn.addActionListener(event -> this.remove());
        } else {
            removeBtn = null;
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(renameBtn);
        if (removeBtn != null) {
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(removeBtn);
        }
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    @Override
    public void dispose() {
        this.codeArea.getMainWindow().getSettings().saveWindowPos(this);
        super.dispose();
    }

    private static /* synthetic */ void lambda$apply$1(ICodeComment newComment, List list) {
        list.add(newComment);
    }

    private /* synthetic */ void lambda$apply$0(ICodeComment newComment, List list) {
        list.remove(this.comment);
        list.add(newComment);
    }
}

