/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.ui.codearea.HexAreaConfiguration;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextArea;
import javax.swing.border.MatteBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexPreviewPanel
extends JTextArea {
    private static final Logger LOG = LoggerFactory.getLogger(HexPreviewPanel.class);
    private final HexAreaConfiguration config;
    private byte[] bytes = new byte[0];
    private Color highlightColor = Color.YELLOW;
    private boolean hasHighlight = false;

    public HexPreviewPanel(HexAreaConfiguration configuration) {
        super(0, configuration.bytesPerLine);
        this.config = configuration;
        this.initView();
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            char c = (char)bytes[i];
            if (c <= '\u001f' || (c & 0x80) != 0) {
                sb.append('.');
            } else {
                sb.append(c);
            }
            if (i == bytes.length - 1 || i % this.config.bytesPerLine != this.config.bytesPerLine - 1) continue;
            sb.append('\n');
        }
        this.setText(sb.toString());
    }

    public void clearHighlights() {
        this.hasHighlight = false;
        this.getHighlighter().removeAllHighlights();
    }

    public void highlightBytes(int startOffset, int endOffset) {
        if (this.hasHighlight) {
            this.getHighlighter().removeAllHighlights();
        }
        startOffset += startOffset / this.config.bytesPerLine;
        endOffset += endOffset / this.config.bytesPerLine;
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(this.highlightColor);
        try {
            this.getHighlighter().addHighlight(startOffset, endOffset + 1, painter);
        }
        catch (BadLocationException e) {
            LOG.error("Unable to highlight bytes " + startOffset + ":" + endOffset, (Throwable)e);
        }
        this.hasHighlight = true;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setBorderColor(Color borderColor) {
        this.setBorder(new MatteBorder(0, 2, 0, 0, borderColor));
    }

    public void applyTheme(Theme theme, Font font) {
        this.setBackground(theme.bgColor);
        this.setHighlightColor(theme.selectionBG);
        this.setBorderColor(theme.gutterBorderColor);
        this.setDisabledTextColor(theme.scheme.getStyle((int)20).foreground);
        this.setFont(font);
    }

    private void initView() {
        this.setEnabled(false);
        this.setEditable(false);
    }
}

