/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.metadata.annotations.VarNode;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.JNodeAction;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FridaAction
extends JNodeAction {
    private static final Logger LOG = LoggerFactory.getLogger(FridaAction.class);
    private static final long serialVersionUID = -3084073927621269039L;

    public FridaAction(CodeArea codeArea) {
        super(ActionModel.FRIDA_COPY, codeArea);
    }

    @Override
    public void runAction(JNode node) {
        try {
            String fridaSnippet = this.generateFridaSnippet(node);
            LOG.info("Frida snippet:\n{}", (Object)fridaSnippet);
            UiUtils.copyToClipboard(fridaSnippet);
        }
        catch (Exception e) {
            LOG.error("Failed to generate Frida code snippet", (Throwable)e);
            JOptionPane.showMessageDialog(this.getCodeArea().getMainWindow(), e.getLocalizedMessage(), NLS.str("error_dialog.title"), 0);
        }
    }

    @Override
    public boolean isActionEnabled(JNode node) {
        return node instanceof JMethod || node instanceof JClass || node instanceof JField;
    }

    private String generateFridaSnippet(JNode node) {
        if (node instanceof JMethod) {
            return this.generateMethodSnippet((JMethod)node);
        }
        if (node instanceof JClass) {
            return this.generateClassAllMethodSnippet((JClass)node);
        }
        if (node instanceof JField) {
            return this.generateFieldSnippet((JField)node);
        }
        throw new JadxRuntimeException("Unsupported node type: " + (Serializable)(node != null ? node.getClass() : "null"));
    }

    private String generateMethodSnippet(JMethod jMth) {
        return this.getMethodSnippet(jMth.getJavaMethod(), jMth.getJParent());
    }

    private String generateMethodSnippet(JavaMethod javaMethod, JClass jc) {
        return this.getMethodSnippet(javaMethod, jc);
    }

    private String getMethodSnippet(JavaMethod javaMethod, JClass jc) {
        Object overload;
        String newMethodName;
        String methodName;
        MethodNode mth = javaMethod.getMethodNode();
        MethodInfo methodInfo = mth.getMethodInfo();
        if (methodInfo.isConstructor()) {
            newMethodName = methodName = "$init";
        } else {
            methodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getName());
            newMethodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getAlias());
        }
        if (this.isOverloaded(mth).booleanValue()) {
            String overloadArgs = methodInfo.getArgumentsTypes().stream().map(this::parseArgType).collect(Collectors.joining(", "));
            overload = ".overload(" + overloadArgs + ")";
        } else {
            overload = "";
        }
        List argNames = mth.collectArgNodes().stream().map(VarNode::getName).collect(Collectors.toList());
        String args = String.join((CharSequence)", ", argNames);
        Object logArgs = argNames.isEmpty() ? "" : ": " + argNames.stream().map(arg -> arg + "=${" + arg + "}").collect(Collectors.joining(", "));
        String shortClassName = mth.getParentClass().getAlias();
        String classSnippet = this.generateClassSnippet(jc);
        if (methodInfo.isConstructor() || methodInfo.getReturnType() == ArgType.VOID) {
            return classSnippet + "\n" + shortClassName + "[\"" + methodName + "\"]" + (String)overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + (String)logArgs + "`);\n    this[\"" + methodName + "\"](" + args + ");\n};";
        }
        return classSnippet + "\n" + shortClassName + "[\"" + methodName + "\"]" + (String)overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + (String)logArgs + "`);\n    let result = this[\"" + methodName + "\"](" + args + ");\n    console.log(`" + shortClassName + "." + newMethodName + " result=${result}`);\n    return result;\n};";
    }

    private String generateClassSnippet(JClass jc) {
        JavaClass javaClass = jc.getCls();
        String rawClassName = StringEscapeUtils.escapeEcmaScript((String)javaClass.getRawName());
        String shortClassName = javaClass.getName();
        return String.format("let %s = Java.use(\"%s\");", shortClassName, rawClassName);
    }

    private String generateClassAllMethodSnippet(JClass jc) {
        JavaClass javaClass = jc.getCls();
        Object result = "";
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            result = (String)result + this.generateMethodSnippet(javaMethod, jc) + "\n";
        }
        return result;
    }

    private String generateFieldSnippet(JField jf) {
        JavaField javaField = jf.getJavaField();
        Object rawFieldName = StringEscapeUtils.escapeEcmaScript((String)javaField.getRawName());
        String fieldName = javaField.getName();
        List methodNodes = javaField.getFieldNode().getParentClass().getMethods();
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.getName().equals(rawFieldName)) continue;
            rawFieldName = "_" + (String)rawFieldName;
            break;
        }
        JClass jc = jf.getRootClass();
        String classSnippet = this.generateClassSnippet(jc);
        return String.format("%s\n%s = %s.%s.value;", classSnippet, fieldName, jc.getName(), rawFieldName);
    }

    public Boolean isOverloaded(MethodNode methodNode) {
        return methodNode.getParentClass().getMethods().stream().anyMatch(m -> m.getName().equals(methodNode.getName()) && !Objects.equals(methodNode.getMethodInfo().getShortId(), m.getMethodInfo().getShortId()));
    }

    private String parseArgType(ArgType x) {
        String typeStr = x.isArray() ? TypeGen.signature((ArgType)x).replace("/", ".") : x.toString();
        return "'" + typeStr + "'";
    }
}

