/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodePanel;
import jadx.gui.ui.codearea.HexArea;
import jadx.gui.ui.codearea.HexConfigurationPanel;
import jadx.gui.ui.tab.TabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class BinaryContentPanel
extends AbstractCodeContentPanel {
    private final transient CodePanel textCodePanel;
    private final transient CodePanel hexCodePanel;
    private final transient HexConfigurationPanel hexConfigurationPanel;
    private final transient JTabbedPane areaTabbedPane;

    public BinaryContentPanel(TabbedPane panel, JNode jnode) {
        this(panel, jnode, true);
    }

    public BinaryContentPanel(TabbedPane panel, JNode jnode, boolean supportsText) {
        super(panel, jnode);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textCodePanel = supportsText ? new CodePanel(new CodeArea(this, jnode)) : null;
        HexArea hexArea = new HexArea(this, jnode);
        this.hexConfigurationPanel = new HexConfigurationPanel(hexArea.getConfiguration());
        hexArea.setConfigurationPanel(this.hexConfigurationPanel);
        this.hexCodePanel = new CodePanel(hexArea);
        this.areaTabbedPane = this.buildTabbedPane();
        this.add(this.areaTabbedPane);
        this.getSelectedPanel().load();
    }

    private JTabbedPane buildTabbedPane() {
        JSplitPane hexSplitPanel = new JSplitPane(1, this.hexCodePanel, this.hexConfigurationPanel);
        hexSplitPanel.setResizeWeight(0.8);
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        tabbedPane.setTabLayoutPolicy(1);
        if (this.textCodePanel != null) {
            tabbedPane.add((Component)this.textCodePanel, "Text");
        }
        tabbedPane.add((Component)hexSplitPanel, "Hex");
        tabbedPane.addChangeListener(e -> this.getSelectedPanel().load());
        return tabbedPane;
    }

    @Override
    public AbstractCodeArea getCodeArea() {
        if (this.textCodePanel != null) {
            return this.textCodePanel.getCodeArea();
        }
        return this.hexCodePanel.getCodeArea();
    }

    @Override
    public void loadSettings() {
        if (this.textCodePanel != null) {
            this.textCodePanel.loadSettings();
        }
        this.hexCodePanel.loadSettings();
        this.updateUI();
    }

    @Override
    public JadxSettings getSettings() {
        JadxSettings settings = super.getSettings();
        settings.setLineNumbersMode(LineNumbersMode.NORMAL);
        return settings;
    }

    private CodePanel getSelectedPanel() {
        CodePanel selectedPanel;
        Component selectedComponent = this.areaTabbedPane.getSelectedComponent();
        if (selectedComponent instanceof CodePanel) {
            selectedPanel = (CodePanel)selectedComponent;
        } else if (selectedComponent instanceof JSplitPane) {
            selectedPanel = (CodePanel)((JSplitPane)selectedComponent).getLeftComponent();
        } else {
            throw new RuntimeException("tabbedPane.getSelectedComponent returned a Component of unexpected type " + selectedComponent);
        }
        return selectedPanel;
    }
}

