/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.JavaVariable;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.deobf.NameMapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.UiUtils;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class JVariable
extends JNode
implements JRenameNode {
    private static final long serialVersionUID = -3002100457834453783L;
    private final JMethod jMth;
    private final JavaVariable var;

    public JVariable(JMethod jMth, JavaVariable var) {
        this.jMth = jMth;
        this.var = var;
    }

    public JavaVariable getJavaVarNode() {
        return this.var;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.var;
    }

    @Override
    public JClass getRootClass() {
        return this.jMth.getRootClass();
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.var.getVarNode();
    }

    @Override
    public JClass getJParent() {
        return this.jMth.getJParent();
    }

    @Override
    public int getPos() {
        return this.var.getDefPos();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String makeString() {
        return this.var.getName();
    }

    @Override
    public String makeLongString() {
        return this.var.getFullName();
    }

    @Override
    public String makeLongStringHtml() {
        return UiUtils.typeFormatHtml(this.var.getName(), this.var.getType());
    }

    @Override
    public boolean disableHtml() {
        return false;
    }

    @Override
    public String getTooltip() {
        String name = this.var.getName() + " (r" + this.var.getReg() + "v" + this.var.getSsa() + ")";
        String fullType = UiUtils.escapeHtml(this.var.getType().toString());
        return UiUtils.wrapHtml(fullType + " " + UiUtils.escapeHtml(name));
    }

    @Override
    public boolean canRename() {
        return this.var.getName() != null;
    }

    @Override
    public String getTitle() {
        return this.makeLongStringHtml();
    }

    @Override
    public boolean isValidName(String newName) {
        return NameMapper.isValidIdentifier((String)newName);
    }

    @Override
    public ICodeRename buildCodeRename(String newName, Set<ICodeRename> renames) {
        return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forMth((JavaMethod)this.var.getMth()), (IJavaCodeRef)JadxCodeRef.forVar((JavaVariable)this.var), newName);
    }

    @Override
    public void removeAlias() {
        this.var.removeAlias();
    }

    @Override
    public void addUpdateNodes(List<JavaNode> toUpdate) {
        toUpdate.add((JavaNode)this.var.getMth());
    }

    @Override
    public void reload(MainWindow mainWindow) {
    }
}

