/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JRoot;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.pkgs.PackageHelper;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JSources
extends JNode {
    private static final long serialVersionUID = 8962924556824862801L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/packageClasses");
    private final transient JadxWrapper wrapper;
    private final transient boolean flatPackages;

    public JSources(JRoot jRoot, JadxWrapper wrapper) {
        this.flatPackages = jRoot.isFlatPackages();
        this.wrapper = wrapper;
        this.update();
    }

    public final void update() {
        this.removeAllChildren();
        PackageHelper packageHelper = this.wrapper.getCache().getPackageHelper();
        if (packageHelper == null) {
            packageHelper = new PackageHelper(this.wrapper);
            this.wrapper.getCache().setPackageHelper(packageHelper);
        }
        List<JPackage> roots = packageHelper.getRoots(this.flatPackages);
        for (JPackage rootPkg : roots) {
            rootPkg.update();
            this.add(rootPkg);
        }
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String makeString() {
        return NLS.str("tree.sources_title");
    }
}

