/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui;

import jadx.api.plugins.gui.ISettingsGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SettingsGroup
implements ISettingsGroup {
    private final String title;
    private final JPanel panel;
    private final JPanel gridPanel;
    private final GridBagConstraints c;
    private int row;

    public SettingsGroup(String title) {
        this.title = title;
        this.gridPanel = new JPanel(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.weighty = 1.0;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.panel.setBorder(BorderFactory.createTitledBorder(title));
        this.panel.add((Component)this.gridPanel, "First");
    }

    public JLabel addRow(String label, JComponent comp) {
        return this.addRow(label, null, comp);
    }

    public JLabel addRow(String label, String tooltip, JComponent comp) {
        this.c.gridy = this.row++;
        JLabel rowLbl = new JLabel(label);
        rowLbl.setLabelFor(comp);
        rowLbl.setHorizontalAlignment(2);
        this.c.gridx = 0;
        this.c.gridwidth = 1;
        this.c.anchor = 21;
        this.c.weightx = 0.1;
        this.c.fill = 21;
        this.gridPanel.add((Component)rowLbl, this.c);
        this.c.gridx = 1;
        this.c.gridwidth = 0;
        this.c.anchor = 21;
        this.c.weightx = 0.7;
        this.c.fill = 21;
        if (tooltip != null) {
            rowLbl.setToolTipText(tooltip);
            comp.setToolTipText(tooltip);
        }
        this.gridPanel.add((Component)comp, this.c);
        comp.addPropertyChangeListener("enabled", evt -> rowLbl.setEnabled((Boolean)evt.getNewValue()));
        return rowLbl;
    }

    public void end() {
        this.gridPanel.add(Box.createVerticalGlue());
    }

    public JComponent buildComponent() {
        return this.panel;
    }

    public String getTitle() {
        return this.title;
    }

    public JPanel getGridPanel() {
        return this.gridPanel;
    }

    public String toString() {
        return this.title;
    }
}

