/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.ICodeCache;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeMetadata;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.utils.CodeUtils;
import jadx.core.utils.Utils;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.SearchSettings;
import jadx.gui.search.providers.BaseSearchProvider;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeSearchProvider
extends BaseSearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CodeSearchProvider.class);
    private final ICodeCache codeCache;
    private final JadxWrapper wrapper;
    @Nullable
    private String code;
    private int clsNum = 0;
    private int pos = 0;

    public CodeSearchProvider(MainWindow mw, SearchSettings searchSettings, List<JavaClass> classes) {
        super(mw, searchSettings, classes);
        this.codeCache = mw.getWrapper().getArgs().getCodeCache();
        this.wrapper = mw.getWrapper();
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        while (!cancelable.isCanceled() && this.clsNum < this.classes.size()) {
            JNode newResult;
            JavaClass cls = (JavaClass)this.classes.get(this.clsNum);
            String clsCode = this.code;
            if (clsCode == null && !cls.isInner() && !cls.isNoCode()) {
                clsCode = this.getClassCode(cls, this.codeCache);
            }
            if (clsCode != null && (newResult = this.searchNext(cls, clsCode)) != null) {
                this.code = clsCode;
                return newResult;
            }
            ++this.clsNum;
            this.pos = 0;
            this.code = null;
        }
        return null;
    }

    @Nullable
    private JNode searchNext(JavaClass javaClass, String clsCode) {
        int newPos = this.searchMth.find(clsCode, this.searchStr, this.pos);
        if (newPos == -1) {
            return null;
        }
        int lineStart = 1 + CodeUtils.getNewLinePosBefore((String)clsCode, (int)newPos);
        int lineEnd = CodeUtils.getNewLinePosAfter((String)clsCode, (int)newPos);
        int end = lineEnd == -1 ? clsCode.length() : lineEnd;
        String line = clsCode.substring(lineStart, end);
        this.pos = end;
        JClass rootCls = this.convert(javaClass);
        JNode enclosingNode = (JNode)Utils.getOrElse((Object)this.getEnclosingNode(javaClass, end), (Object)rootCls);
        return new CodeNode(rootCls, enclosingNode, line.trim(), newPos);
    }

    @Nullable
    private JNode getEnclosingNode(JavaClass javaCls, int pos) {
        try {
            ICodeMetadata metadata = javaCls.getCodeInfo().getCodeMetadata();
            ICodeNodeRef nodeRef = metadata.getNodeAt(pos);
            JavaNode encNode = this.wrapper.getJavaNodeByRef(nodeRef);
            if (encNode != null) {
                return this.convert(encNode);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to resolve enclosing node", (Throwable)e);
        }
        return null;
    }

    private String getClassCode(JavaClass javaClass, ICodeCache codeCache) {
        try {
            String code = codeCache.getCode(javaClass.getRawName());
            if (code != null) {
                return code;
            }
            return javaClass.getCode();
        }
        catch (Exception e) {
            LOG.warn("Failed to get class code: " + javaClass, (Throwable)e);
            return "";
        }
    }

    @Override
    public int progress() {
        return this.clsNum;
    }
}

