/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.script;

import jadx.gui.plugins.script.JadxLintError;
import jadx.gui.plugins.script.ScriptCodeArea;
import java.util.List;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptErrorService
extends AbstractParser {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptErrorService.class);
    private final DefaultParseResult result;
    private final ScriptCodeArea scriptArea;

    public ScriptErrorService(ScriptCodeArea scriptArea) {
        this.scriptArea = scriptArea;
        this.result = new DefaultParseResult((Parser)this);
    }

    public ParseResult parse(RSyntaxDocument doc, String style) {
        return this.result;
    }

    public void clearErrors() {
        this.result.clearNotices();
        this.scriptArea.removeParser((Parser)this);
    }

    public void apply() {
        this.scriptArea.removeParser((Parser)this);
        this.scriptArea.addParser((Parser)this);
        this.scriptArea.addNotify();
        this.scriptArea.requestFocus();
        this.jumpCaretToFirstError();
    }

    private void jumpCaretToFirstError() {
        List parserNotices = this.result.getNotices();
        if (parserNotices.isEmpty()) {
            return;
        }
        ParserNotice notice = (ParserNotice)parserNotices.get(0);
        int offset = notice.getOffset();
        if (offset == -1) {
            try {
                offset = this.scriptArea.getLineStartOffset(notice.getLine());
            }
            catch (Exception e) {
                LOG.error("Failed to jump to first error", (Throwable)e);
                return;
            }
        }
        this.scriptArea.scrollToPos(offset);
    }

    public void addCompilerIssues(List<ScriptDiagnostic> issues) {
        for (ScriptDiagnostic issue : issues) {
            DefaultParserNotice notice;
            if (issue.getSeverity() == ScriptDiagnostic.Severity.DEBUG) continue;
            SourceCode.Location loc = issue.getLocation();
            if (loc == null) {
                notice = new DefaultParserNotice((Parser)this, issue.getMessage(), 0);
            } else {
                try {
                    int line = loc.getStart().getLine();
                    int offset = this.scriptArea.getLineStartOffset(line - 1) + loc.getStart().getCol();
                    int len = loc.getEnd() == null ? -1 : loc.getEnd().getCol() - loc.getStart().getCol();
                    notice = new DefaultParserNotice((Parser)this, issue.getMessage(), line, offset - 1, len);
                    notice.setLevel(ScriptErrorService.convertLevel(issue.getSeverity()));
                }
                catch (Exception e) {
                    LOG.error("Failed to convert script issue", (Throwable)e);
                    continue;
                }
            }
            this.addNotice(notice);
        }
    }

    private static ParserNotice.Level convertLevel(ScriptDiagnostic.Severity severity) {
        switch (severity) {
            case FATAL: 
            case ERROR: {
                return ParserNotice.Level.ERROR;
            }
            case WARNING: {
                return ParserNotice.Level.WARNING;
            }
            case INFO: 
            case DEBUG: {
                return ParserNotice.Level.INFO;
            }
        }
        return ParserNotice.Level.ERROR;
    }

    public void addLintErrors(List<JadxLintError> errors) {
        for (JadxLintError error : errors) {
            try {
                int line = error.getLine();
                int offset = this.scriptArea.getLineStartOffset(line - 1) + error.getCol() - 1;
                String word = this.scriptArea.getWordByPosition(offset);
                int len = word != null ? word.length() : -1;
                DefaultParserNotice notice = new DefaultParserNotice((Parser)this, error.getDetail(), line, offset, len);
                notice.setLevel(ParserNotice.Level.WARNING);
                this.addNotice(notice);
            }
            catch (Exception e) {
                LOG.error("Failed to convert lint error", (Throwable)e);
            }
        }
    }

    private void addNotice(DefaultParserNotice notice) {
        LOG.debug("Add notice: {}:{}:{} - {}", new Object[]{notice.getLine(), notice.getOffset(), notice.getLength(), notice.getMessage()});
        this.result.addNotice((ParserNotice)notice);
    }
}

