/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.script;

import jadx.gui.logs.LogOptions;
import jadx.gui.plugins.script.JadxLintError;
import jadx.gui.plugins.script.KtLintUtils;
import jadx.gui.plugins.script.ScriptCodeArea;
import jadx.gui.plugins.script.ScriptErrorService;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.treemodel.JInputScript;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JadxGuiAction;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import jadx.plugins.script.ide.ScriptAnalyzeResult;
import jadx.plugins.script.ide.ScriptServices;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptContentPanel
extends AbstractCodeContentPanel {
    private static final long serialVersionUID = 6575696321112417513L;
    private final ScriptCodeArea scriptArea;
    private final SearchBar searchBar;
    private final RTextScrollPane codeScrollPane;
    private final JPanel actionPanel;
    private final JLabel resultLabel;
    private final ScriptErrorService errorService;
    private final Logger scriptLog;

    public ScriptContentPanel(TabbedPane panel, JInputScript scriptNode) {
        super(panel, scriptNode);
        this.scriptArea = new ScriptCodeArea((ContentPanel)this, scriptNode);
        this.resultLabel = new NodeLabel("");
        this.errorService = new ScriptErrorService(this.scriptArea);
        this.actionPanel = this.buildScriptActionsPanel();
        this.searchBar = new SearchBar(this.scriptArea);
        this.codeScrollPane = new RTextScrollPane((RTextArea)this.scriptArea);
        this.scriptLog = LoggerFactory.getLogger((String)("JadxScript:" + scriptNode.getName()));
        this.initUI();
        this.applySettings();
        this.scriptArea.load();
    }

    private void initUI() {
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        topPanel.add((Component)this.actionPanel, "North");
        topPanel.add((Component)this.searchBar, "South");
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        codePanel.add((Component)this.codeScrollPane);
        codePanel.add((Component)new ErrorStrip((RSyntaxTextArea)this.scriptArea), "After");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)topPanel, "North");
        this.add((Component)this.codeScrollPane, "Center");
        KeyStroke key = KeyStroke.getKeyStroke(70, UiUtils.ctrlButton());
        UiUtils.addKeyBinding((JComponent)((Object)this.scriptArea), key, "SearchAction", this.searchBar::toggle);
    }

    private JPanel buildScriptActionsPanel() {
        JadxGuiAction runAction = new JadxGuiAction(ActionModel.SCRIPT_RUN, this::runScript);
        JadxGuiAction saveAction = new JadxGuiAction(ActionModel.SCRIPT_SAVE, this.scriptArea::save);
        runAction.setShortcutComponent((JComponent)((Object)this.scriptArea));
        saveAction.setShortcutComponent((JComponent)((Object)this.scriptArea));
        this.tabbedPane.getMainWindow().getShortcutsController().bindImmediate(runAction);
        this.tabbedPane.getMainWindow().getShortcutsController().bindImmediate(saveAction);
        JButton save = saveAction.makeButton();
        this.scriptArea.getScriptNode().addChangeListener(save::setEnabled);
        JButton check = new JButton(NLS.str("script.check"), Icons.CHECK);
        check.addActionListener(ev -> this.checkScript());
        JButton format = new JButton(NLS.str("script.format"), Icons.FORMAT);
        format.addActionListener(ev -> this.reformatCode());
        JButton scriptLog = new JButton(NLS.str("script.log"), Icons.FORMAT);
        scriptLog.addActionListener(ev -> this.showScriptLog());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add(runAction.makeButton());
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(save);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(check);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(format);
        panel.add(Box.createRigidArea(new Dimension(30, 0)));
        panel.add(this.resultLabel);
        panel.add(Box.createHorizontalGlue());
        panel.add(scriptLog);
        return panel;
    }

    private void runScript() {
        this.scriptArea.save();
        if (!this.checkScript()) {
            return;
        }
        this.resetResultLabel();
        TabbedPane tabbedPane = this.getTabbedPane();
        MainWindow mainWindow = tabbedPane.getMainWindow();
        mainWindow.getBackgroundExecutor().execute(NLS.str("script.run"), () -> {
            try {
                mainWindow.getWrapper().reloadPasses();
            }
            catch (Exception e) {
                this.scriptLog.error("Passes reload failed", (Throwable)e);
            }
        }, taskStatus -> mainWindow.passesReloaded());
    }

    private boolean checkScript() {
        try {
            this.resetResultLabel();
            String code = this.scriptArea.getText();
            String fileName = this.scriptArea.getNode().getName();
            ScriptServices scriptServices = new ScriptServices();
            ScriptAnalyzeResult result = scriptServices.analyze(fileName, code);
            boolean success = result.getSuccess();
            List issues = result.getIssues();
            for (ScriptDiagnostic issue : issues) {
                ScriptDiagnostic.Severity severity = issue.getSeverity();
                if (severity == ScriptDiagnostic.Severity.ERROR || severity == ScriptDiagnostic.Severity.FATAL) {
                    this.scriptLog.error("{}", (Object)issue.render(false, true, true, true));
                    success = false;
                    continue;
                }
                if (severity != ScriptDiagnostic.Severity.WARNING) continue;
                this.scriptLog.warn("Compile issue: {}", (Object)issue);
            }
            List<JadxLintError> lintErrs = Collections.emptyList();
            if (success) {
                lintErrs = this.getLintIssues(code);
            }
            this.errorService.clearErrors();
            this.errorService.addCompilerIssues(issues);
            this.errorService.addLintErrors(lintErrs);
            if (!success) {
                this.resultLabel.setText("Compile issues: " + issues.size());
                this.showScriptLog();
            } else if (!lintErrs.isEmpty()) {
                this.resultLabel.setText("Lint issues: " + lintErrs.size());
            } else {
                this.resultLabel.setText("OK");
            }
            this.errorService.apply();
            return success;
        }
        catch (Throwable e) {
            this.scriptLog.error("Failed to check code", e);
            return true;
        }
    }

    private List<JadxLintError> getLintIssues(String code) {
        try {
            List<JadxLintError> lintErrs = KtLintUtils.INSTANCE.lint(code);
            for (JadxLintError error : lintErrs) {
                this.scriptLog.warn("Lint issue: {} ({}:{})(ruleId={})", new Object[]{error.getDetail(), error.getLine(), error.getCol(), error.getRuleId()});
            }
            return lintErrs;
        }
        catch (Throwable e) {
            this.scriptLog.warn("KtLint failed", e);
            return Collections.emptyList();
        }
    }

    private void reformatCode() {
        this.resetResultLabel();
        try {
            String code = this.scriptArea.getText();
            String formattedCode = KtLintUtils.INSTANCE.format(code);
            if (!code.equals(formattedCode)) {
                this.scriptArea.updateCode(formattedCode);
                this.resultLabel.setText("Code updated");
                this.errorService.clearErrors();
            }
        }
        catch (Throwable e) {
            this.scriptLog.error("Failed to reformat code", e);
        }
    }

    private void resetResultLabel() {
        this.resultLabel.setText("");
    }

    private void applySettings() {
        JadxSettings settings = this.getSettings();
        this.codeScrollPane.setLineNumbersEnabled(settings.getLineNumbersMode() != LineNumbersMode.DISABLE);
        this.codeScrollPane.getGutter().setLineNumberFont(settings.getFont());
        this.scriptArea.loadSettings();
    }

    private void showScriptLog() {
        this.getMainWindow().showLogViewer(LogOptions.forScript(this.getNode().getName()));
    }

    @Override
    public AbstractCodeArea getCodeArea() {
        return this.scriptArea;
    }

    @Override
    public void loadSettings() {
        this.applySettings();
        this.updateUI();
    }

    @Override
    public void dispose() {
        this.scriptArea.dispose();
    }
}

