/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.script;

import jadx.api.ICodeInfo;
import jadx.gui.plugins.script.ScriptCompleteProvider;
import jadx.gui.plugins.script.ScriptCompletionRenderer;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JInputScript;
import jadx.gui.ui.action.JadxAutoCompletion;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.shortcut.ShortcutsController;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.jetbrains.annotations.NotNull;

public class ScriptCodeArea
extends AbstractCodeArea {
    private final JInputScript scriptNode;
    private final AutoCompletion autoCompletion;
    private final ShortcutsController shortcutsController;

    public ScriptCodeArea(ContentPanel contentPanel, JInputScript node) {
        super(contentPanel, node);
        this.scriptNode = node;
        this.setSyntaxEditingStyle(node.getSyntaxName());
        this.setCodeFoldingEnabled(true);
        this.setCloseCurlyBraces(true);
        this.shortcutsController = contentPanel.getMainWindow().getShortcutsController();
        JadxSettings settings = contentPanel.getMainWindow().getSettings();
        this.autoCompletion = this.addAutoComplete(settings);
    }

    private AutoCompletion addAutoComplete(JadxSettings settings) {
        ScriptCompleteProvider provider = new ScriptCompleteProvider(this);
        provider.setAutoActivationRules(false, ".");
        JadxAutoCompletion ac = new JadxAutoCompletion((CompletionProvider)provider);
        ac.setListCellRenderer((ListCellRenderer)((Object)new ScriptCompletionRenderer(settings)));
        ac.setAutoActivationEnabled(true);
        ac.setAutoCompleteSingleChoices(true);
        ac.install((JTextComponent)((Object)this));
        this.shortcutsController.bindImmediate(ac);
        return ac;
    }

    @Override
    @NotNull
    public ICodeInfo getCodeInfo() {
        return this.node.getCodeInfo();
    }

    @Override
    public void load() {
        if (this.getText().isEmpty()) {
            this.setText(this.getCodeInfo().getCodeStr());
            this.setCaretPosition(0);
            this.setLoaded();
        }
    }

    @Override
    public void refresh() {
        this.setText(this.node.getCodeInfo().getCodeStr());
    }

    public void updateCode(String newCode) {
        int caretPos = this.getCaretPosition();
        this.setText(newCode);
        this.setCaretPosition(caretPos);
        this.scriptNode.setChanged(true);
    }

    public void save() {
        this.scriptNode.save(this.getText());
        this.scriptNode.setChanged(false);
    }

    public JInputScript getScriptNode() {
        return this.scriptNode;
    }

    @Override
    public void dispose() {
        this.shortcutsController.unbindActionsForComponent((JComponent)((Object)this));
        this.autoCompletion.uninstall();
        super.dispose();
    }
}

