/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import ch.qos.logback.classic.Level;
import jadx.core.utils.Utils;
import jadx.gui.logs.LogMode;
import org.jetbrains.annotations.Nullable;

public class LogOptions {
    private static LogOptions current = new LogOptions(LogMode.ALL, Level.INFO, null);
    private final LogMode mode;
    private final Level logLevel;
    @Nullable
    private final String filter;

    public static LogOptions allWithLevel(@Nullable Level logLevel) {
        Level level = (Level)Utils.getOrElse((Object)logLevel, (Object)current.getLogLevel());
        return LogOptions.store(new LogOptions(LogMode.ALL, level, null));
    }

    public static LogOptions forLevel(@Nullable Level logLevel) {
        Level level = (Level)Utils.getOrElse((Object)logLevel, (Object)current.getLogLevel());
        return LogOptions.store(new LogOptions(current.getMode(), level, current.getFilter()));
    }

    public static LogOptions forMode(LogMode mode) {
        return LogOptions.store(new LogOptions(mode, current.getLogLevel(), current.getFilter()));
    }

    public static LogOptions forScript(String scriptName) {
        String filter = "JadxScript:" + scriptName;
        return LogOptions.store(new LogOptions(LogMode.CURRENT_SCRIPT, current.getLogLevel(), filter));
    }

    public static LogOptions current() {
        return current;
    }

    private static LogOptions store(LogOptions logOptions) {
        current = logOptions;
        return logOptions;
    }

    private LogOptions(LogMode mode, Level logLevel, @Nullable String filter) {
        this.mode = mode;
        this.logLevel = logLevel;
        this.filter = filter;
    }

    public LogMode getMode() {
        return this.mode;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    public String toString() {
        return "LogOptions{mode=" + this.mode + ", logLevel=" + this.logLevel + ", filter='" + this.filter + "'}";
    }
}

