/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code;

import io.reactivex.disposables.Disposable;
import io.reactivex.processors.PublishProcessor;
import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.impl.DelegateCodeCache;
import jadx.gui.utils.UiUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeStringCache
extends DelegateCodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(CodeStringCache.class);
    private final Map<String, String> codeCache = new ConcurrentHashMap<String, String>();
    private final Subscriber<Boolean> subscriber;
    private final Disposable disposable;

    public CodeStringCache(ICodeCache backCache) {
        super(backCache);
        PublishProcessor processor;
        this.subscriber = processor = PublishProcessor.create();
        this.disposable = processor.debounce(3L, TimeUnit.SECONDS).map(v -> UiUtils.isFreeMemoryAvailable()).filter(v -> v == false).subscribe(v -> {
            LOG.warn("Free memory is low! Reset code strings cache. Cache size {}", (Object)this.codeCache.size());
            this.codeCache.clear();
            System.gc();
        });
    }

    @Nullable
    public String getCode(String clsFullName) {
        this.subscriber.onNext((Object)Boolean.TRUE);
        String code = this.codeCache.get(clsFullName);
        if (code != null) {
            return code;
        }
        String backCode = this.backCache.getCode(clsFullName);
        if (backCode != null) {
            this.codeCache.put(clsFullName, backCode);
        }
        return backCode;
    }

    @NotNull
    public ICodeInfo get(String clsFullName) {
        this.subscriber.onNext((Object)Boolean.TRUE);
        return super.get(clsFullName);
    }

    public void add(String clsFullName, ICodeInfo codeInfo) {
        this.subscriber.onNext((Object)Boolean.TRUE);
        this.codeCache.put(clsFullName, codeInfo.getCodeStr());
        this.backCache.add(clsFullName, codeInfo);
    }

    public void remove(String clsFullName) {
        this.codeCache.remove(clsFullName);
        this.backCache.remove(clsFullName);
    }

    public void close() throws IOException {
        try {
            this.backCache.close();
        }
        finally {
            this.codeCache.clear();
            this.subscriber.onComplete();
            this.disposable.dispose();
        }
    }
}

