/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex;

import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.impl.EmptyLoadResult;
import jadx.plugins.input.dex.DexFileLoader;
import jadx.plugins.input.dex.DexLoadResult;
import jadx.plugins.input.dex.DexReader;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;

public class DexInputPlugin
implements JadxInputPlugin {
    public DexInputPlugin() {
        DexFileLoader.resetDexUniqId();
    }

    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo("dex-input", "DexInput", "Load .dex and .apk files");
    }

    public ILoadResult loadFiles(List<Path> input) {
        return DexInputPlugin.loadDexFiles(input, null);
    }

    public static ILoadResult loadDexFiles(List<Path> inputFiles, Closeable closeable) {
        List<DexReader> dexReaders = DexFileLoader.collectDexFiles(inputFiles);
        if (dexReaders.isEmpty()) {
            return EmptyLoadResult.INSTANCE;
        }
        return new DexLoadResult(dexReaders, closeable);
    }
}

