/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class ParserStream
extends InputStream {
    protected static final Charset STRING_CHARSET_UTF16 = StandardCharsets.UTF_16LE;
    protected static final Charset STRING_CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final InputStream input;
    private long readPos = 0L;
    private long markPos = 0L;

    public ParserStream(@NotNull InputStream inputStream) {
        this.input = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
    }

    public long getPos() {
        return this.readPos;
    }

    public int readInt8() throws IOException {
        ++this.readPos;
        return this.input.read();
    }

    public int readInt16() throws IOException {
        this.readPos += 2L;
        int b1 = this.input.read();
        int b2 = this.input.read();
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int readInt32() throws IOException {
        this.readPos += 4L;
        InputStream in = this.input;
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        return b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public long readUInt32() throws IOException {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    public String readString16Fixed(int len) throws IOException {
        String str = new String(this.readInt8Array(len * 2), STRING_CHARSET_UTF16);
        return str.trim();
    }

    public int[] readInt32Array(int count) throws IOException {
        if (count == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] arr = new int[count];
        for (int i = 0; i < count; ++i) {
            arr[i] = this.readInt32();
        }
        return arr;
    }

    public byte[] readInt8Array(int count) throws IOException {
        int read;
        if (count == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        this.readPos += (long)count;
        byte[] arr = new byte[count];
        for (int pos = this.input.read(arr, 0, count); pos < count; pos += read) {
            read = this.input.read(arr, pos, count - pos);
            if (read != -1) continue;
            throw new IOException("No data, can't read " + count + " bytes");
        }
        return arr;
    }

    @Override
    public long skip(long count) throws IOException {
        long pos;
        long skipped;
        this.readPos += count;
        for (pos = this.input.skip(count); pos < count; pos += skipped) {
            skipped = this.input.skip(count - pos);
            if (skipped != 0L) continue;
            throw new IOException("No data, can't skip " + count + " bytes");
        }
        return pos;
    }

    public void checkInt8(int expected, String error) throws IOException {
        int v = this.readInt8();
        if (v != expected) {
            this.throwException(error, expected, v);
        }
    }

    public void checkInt16(int expected, String error) throws IOException {
        int v = this.readInt16();
        if (v != expected) {
            this.throwException(error, expected, v);
        }
    }

    private void throwException(String error, int expected, int actual) throws IOException {
        throw new IOException(error + ", expected: 0x" + Integer.toHexString(expected) + ", actual: 0x" + Integer.toHexString(actual) + ", offset: 0x" + Long.toHexString(this.getPos()));
    }

    public void checkPos(long expectedOffset, String error) throws IOException {
        if (this.getPos() != expectedOffset) {
            throw new IOException(error + ", expected offset: 0x" + Long.toHexString(expectedOffset) + ", actual: 0x" + Long.toHexString(this.getPos()));
        }
    }

    public void skipToPos(long expectedOffset, String error) throws IOException {
        long pos = this.getPos();
        if (pos > expectedOffset) {
            throw new IOException(error + ", expected offset not reachable: 0x" + Long.toHexString(expectedOffset) + ", actual: 0x" + Long.toHexString(this.getPos()));
        }
        if (pos < expectedOffset) {
            this.skip(expectedOffset - pos);
        }
        this.checkPos(expectedOffset, error);
    }

    @Override
    public void mark(int len) {
        if (!this.input.markSupported()) {
            throw new RuntimeException("Mark not supported for input stream " + String.valueOf(this.input.getClass()));
        }
        this.input.mark(len);
        this.markPos = this.readPos;
    }

    @Override
    public void reset() throws IOException {
        this.input.reset();
        this.readPos = this.markPos;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        this.readPos += (long)len;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.input.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    public String toString() {
        return "pos: 0x" + Long.toHexString(this.readPos);
    }
}

