/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins.versions;

import jadx.core.Jadx;
import jadx.core.plugins.versions.VersionComparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class VerifyRequiredVersion {
    private final String jadxVersion;
    private final boolean unstable;
    private final boolean dev;
    private static final Pattern REQ_VER_FORMAT = Pattern.compile("(\\d+\\.\\d+\\.\\d+),\\s+(r\\d+)");

    public static boolean isJadxCompatible(@Nullable String reqVersionStr) {
        return new VerifyRequiredVersion().isCompatible(reqVersionStr);
    }

    public static void verify(String requiredJadxVersion) {
        try {
            VerifyRequiredVersion.parse(requiredJadxVersion);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed 'requiredJadxVersion': " + e.getMessage(), e);
        }
    }

    public VerifyRequiredVersion() {
        this(Jadx.getVersion());
    }

    public VerifyRequiredVersion(String jadxVersion) {
        this.jadxVersion = jadxVersion;
        this.unstable = jadxVersion.startsWith("r");
        this.dev = jadxVersion.equals("dev");
    }

    public boolean isCompatible(@Nullable String reqVersionStr) {
        if (reqVersionStr == null || reqVersionStr.isEmpty()) {
            return true;
        }
        RequiredVersionData reqVer = VerifyRequiredVersion.parse(reqVersionStr);
        if (this.dev) {
            return true;
        }
        if (this.unstable) {
            return VersionComparator.checkAndCompare(this.jadxVersion, reqVer.getUnstableRev()) >= 0;
        }
        return VersionComparator.checkAndCompare(this.jadxVersion, reqVer.getReleaseVer()) >= 0;
    }

    public String getJadxVersion() {
        return this.jadxVersion;
    }

    private static RequiredVersionData parse(String reqVersionStr) {
        Matcher matcher = REQ_VER_FORMAT.matcher(reqVersionStr);
        if (!matcher.matches()) {
            throw new RuntimeException("Expect format: " + String.valueOf(REQ_VER_FORMAT) + ", got: " + reqVersionStr);
        }
        return new RequiredVersionData(matcher.group(1), matcher.group(2));
    }

    private static final class RequiredVersionData {
        private final String releaseVer;
        private final String unstableRev;

        private RequiredVersionData(String releaseVer, String unstableRev) {
            this.releaseVer = releaseVer;
            this.unstableRev = unstableRev;
        }

        public String getReleaseVer() {
            return this.releaseVer;
        }

        public String getUnstableRev() {
            return this.unstableRev;
        }
    }
}

