/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.TypeUpdateEntry;
import jadx.core.dex.visitors.typeinference.TypeUpdateFlags;
import jadx.core.utils.exceptions.JadxOverflowException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeUpdateInfo {
    private final MethodNode mth;
    private final TypeUpdateFlags flags;
    private final Map<InsnArg, TypeUpdateEntry> updateMap = new IdentityHashMap<InsnArg, TypeUpdateEntry>();
    private final int updatesLimitCount;
    private int updateSeq = 0;

    public TypeUpdateInfo(MethodNode mth, TypeUpdateFlags flags) {
        this.mth = mth;
        this.flags = flags;
        this.updatesLimitCount = mth.getInsnsCount() * 10;
    }

    public void requestUpdate(InsnArg arg, ArgType changeType) {
        TypeUpdateEntry prev;
        if ((prev = this.updateMap.put(arg, new TypeUpdateEntry(this.updateSeq++, arg, changeType))) != null) {
            throw new JadxRuntimeException("Unexpected type update override for arg: " + String.valueOf(arg) + " types: prev=" + String.valueOf(prev.getType()) + ", new=" + String.valueOf(changeType) + ", insn: " + String.valueOf(arg.getParentInsn()));
        }
        if (this.updateSeq > this.updatesLimitCount) {
            throw new JadxOverflowException("Type inference error: updates count limit reached");
        }
    }

    public void rollbackUpdate(InsnArg arg) {
        TypeUpdateEntry removed = this.updateMap.remove(arg);
        if (removed != null) {
            int seq = removed.getSeq();
            this.updateMap.values().removeIf(upd -> upd.getSeq() > seq);
        }
    }

    public void applyUpdates() {
        this.updateMap.values().stream().sorted().forEach(upd -> upd.getArg().setType(upd.getType()));
    }

    public boolean isProcessed(InsnArg arg) {
        return this.updateMap.containsKey(arg);
    }

    public boolean hasUpdateWithType(InsnArg arg, ArgType type) {
        TypeUpdateEntry updateEntry = this.updateMap.get(arg);
        if (updateEntry != null) {
            return updateEntry.getType().equals(type);
        }
        return false;
    }

    public ArgType getType(InsnArg arg) {
        TypeUpdateEntry updateEntry = this.updateMap.get(arg);
        if (updateEntry != null) {
            return updateEntry.getType();
        }
        return arg.getType();
    }

    public MethodNode getMth() {
        return this.mth;
    }

    public boolean isEmpty() {
        return this.updateMap.isEmpty();
    }

    public List<TypeUpdateEntry> getSortedUpdates() {
        return this.updateMap.values().stream().sorted().collect(Collectors.toList());
    }

    public TypeUpdateFlags getFlags() {
        return this.flags;
    }

    public String toString() {
        return "TypeUpdateInfo{" + String.valueOf(this.flags) + " " + String.valueOf(this.getSortedUpdates()) + "}";
    }
}

