/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegionStack {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStack.class);
    private static final boolean DEBUG = false;
    private static final int REGIONS_STACK_LIMIT = 1000;
    private final Deque<State> stack = new ArrayDeque<State>();
    private State curState = new State();

    public RegionStack(MethodNode mth) {
    }

    public void push(IRegion region) {
        this.stack.push(this.curState);
        if (this.stack.size() > 1000) {
            throw new JadxOverflowException("Regions stack size limit reached");
        }
        this.curState = this.curState.copyWith(region);
    }

    public void pop() {
        this.curState = this.stack.pop();
    }

    public void addExit(BlockNode exit) {
        if (exit != null) {
            this.curState.exits.add(exit);
        }
    }

    public void addExits(Collection<BlockNode> exits) {
        for (BlockNode exit : exits) {
            this.addExit(exit);
        }
    }

    public void removeExit(BlockNode exit) {
        if (exit != null) {
            this.curState.exits.remove(exit);
        }
    }

    public boolean containsExit(BlockNode exit) {
        return this.curState.exits.contains(exit);
    }

    public IRegion peekRegion() {
        return this.curState.region;
    }

    public int size() {
        return this.stack.size();
    }

    public RegionStack clear() {
        this.stack.clear();
        this.curState = new State();
        return this;
    }

    public String toString() {
        return "Region stack size: " + this.size() + ", last: " + String.valueOf(this.curState);
    }

    private static final class State {
        final Set<BlockNode> exits;
        IRegion region;

        public State() {
            this.exits = new HashSet<BlockNode>();
        }

        private State(State c, IRegion region) {
            this.exits = new HashSet<BlockNode>(c.exits);
            this.region = region;
        }

        public State copyWith(IRegion region) {
            return new State(this, region);
        }

        public String toString() {
            return "Region: " + String.valueOf(this.region) + ", exits: " + String.valueOf(this.exits);
        }
    }
}

