/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.TracedRegionVisitor;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import java.util.ListIterator;

public class ReturnVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isVoidReturn()) {
            DepthRegionTraversal.traverse(mth, new ReturnRemoverVisitor());
        }
    }

    private static final class ReturnRemoverVisitor
    extends TracedRegionVisitor {
        private ReturnRemoverVisitor() {
        }

        @Override
        public boolean enterRegion(MethodNode mth, IRegion region) {
            super.enterRegion(mth, region);
            return !(region instanceof SwitchRegion);
        }

        @Override
        public void processBlockTraced(MethodNode mth, IBlock container, IRegion currentRegion) {
            List<InsnNode> insns;
            if (container.getClass() != BlockNode.class) {
                return;
            }
            BlockNode block = (BlockNode)container;
            if (block.contains(AFlag.RETURN) && (insns = block.getInstructions()).size() == 1 && this.blockNotInLoop(mth, block) && this.noTrailInstructions(block)) {
                insns.remove(0);
                block.remove(AFlag.RETURN);
            }
        }

        private boolean blockNotInLoop(MethodNode mth, BlockNode block) {
            if (mth.getLoopsCount() == 0) {
                return true;
            }
            if (mth.getLoopForBlock(block) != null) {
                return false;
            }
            for (IRegion region : this.regionStack) {
                if (region.getClass() != LoopRegion.class) continue;
                return false;
            }
            return true;
        }

        private boolean noTrailInstructions(BlockNode block) {
            IContainer curContainer = block;
            for (IRegion region : this.regionStack) {
                if (region instanceof IBranchRegion) {
                    curContainer = region;
                    continue;
                }
                List<IContainer> subBlocks = region.getSubBlocks();
                if (!subBlocks.isEmpty()) {
                    IContainer subBlock;
                    ListIterator<IContainer> itSubBlock = subBlocks.listIterator(subBlocks.size());
                    while (itSubBlock.hasPrevious() && (subBlock = itSubBlock.previous()) != curContainer) {
                        if (ReturnRemoverVisitor.isEmpty(subBlock)) continue;
                        return false;
                    }
                }
                curContainer = region;
            }
            return true;
        }

        private static boolean isEmpty(IContainer container) {
            if (container instanceof IBlock) {
                IBlock block = (IBlock)container;
                return block.getInstructions().isEmpty() || block.contains(AFlag.RETURN);
            }
            if (container instanceof IRegion) {
                IRegion region = (IRegion)container;
                for (IContainer block : region.getSubBlocks()) {
                    if (ReturnRemoverVisitor.isEmpty(block)) continue;
                    return false;
                }
                return true;
            }
            throw new JadxRuntimeException("Unknown container type: " + String.valueOf(container.getClass()));
        }
    }
}

