/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.finaly;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class InsnsSlice {
    private final List<InsnNode> insnsList = new ArrayList<InsnNode>();
    private final Map<InsnNode, BlockNode> insnMap = new IdentityHashMap<InsnNode, BlockNode>();
    private boolean complete;

    public void addInsn(InsnNode insn, BlockNode block) {
        this.insnsList.add(insn);
        this.insnMap.put(insn, block);
    }

    public void addBlock(BlockNode block) {
        for (InsnNode insn : block.getInstructions()) {
            this.addInsn(insn, block);
        }
    }

    public void addInsns(BlockNode block, int startIndex, int endIndex) {
        List<InsnNode> insns = block.getInstructions();
        for (int i = startIndex; i < endIndex; ++i) {
            this.addInsn(insns.get(i), block);
        }
    }

    @Nullable
    public BlockNode getBlock(InsnNode insn) {
        return this.insnMap.get(insn);
    }

    public List<InsnNode> getInsnsList() {
        return this.insnsList;
    }

    public Set<BlockNode> getBlocks() {
        LinkedHashSet<BlockNode> set = new LinkedHashSet<BlockNode>();
        for (InsnNode insn : this.insnsList) {
            set.add(this.insnMap.get(insn));
        }
        return set;
    }

    public void resetIncomplete() {
        if (!this.complete) {
            this.insnsList.clear();
            this.insnMap.clear();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String toString() {
        return "{[" + this.insnsList.stream().map(insn -> insn.getType().toString()).collect(Collectors.joining(", ")) + "]" + (this.complete ? " complete" : "") + "}";
    }
}

