/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.options.impl;

import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.api.plugins.options.OptionFlag;
import jadx.api.plugins.options.OptionType;
import jadx.api.plugins.options.impl.OptionBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class BasePluginOptionsBuilder
implements JadxPluginOptions {
    private final List<OptionData<?>> options = new ArrayList();

    public abstract void registerOptions();

    public BasePluginOptionsBuilder() {
        this.registerOptions();
        for (OptionData<?> option : this.options) {
            option.validate();
        }
    }

    public <T> OptionBuilder<T> option(String name) {
        return this.addOption(new OptionData(name));
    }

    public <T> OptionBuilder<T> option(String name, Class<T> optionType) {
        return this.addOption(new OptionData(name));
    }

    public OptionBuilder<Boolean> boolOption(String name) {
        return this.addOption(new OptionData(name).type(OptionType.BOOLEAN).values(Arrays.asList(Boolean.TRUE, Boolean.FALSE)).formatter(b -> b != false ? "yes" : "no").parser(val -> BasePluginOptionsBuilder.parseBoolOption(name, val)));
    }

    public OptionBuilder<String> strOption(String name) {
        return this.addOption(new OptionData(name).type(OptionType.STRING).formatter(v -> v).parser(v -> v));
    }

    public OptionBuilder<Integer> intOption(String name) {
        return this.addOption(new OptionData(name).type(OptionType.NUMBER).formatter(Object::toString).parser(Integer::parseInt));
    }

    public <E extends Enum<?>> OptionBuilder<E> enumOption(String name, E[] values, Function<String, E> valueOf) {
        return this.addOption(new OptionData(name).type(OptionType.STRING).values(Arrays.asList(values)).formatter(v -> v.name().toLowerCase(Locale.ROOT)).parser(v -> (Enum)valueOf.apply(v.toUpperCase(Locale.ROOT))));
    }

    @Override
    public void setOptions(Map<String, String> map) {
        for (OptionData<?> option : this.options) {
            BasePluginOptionsBuilder.parseOption(option, map.get(option.name));
        }
    }

    @Override
    public List<OptionDescription> getOptionsDescriptions() {
        return Collections.unmodifiableList(this.options);
    }

    private static <T> void parseOption(OptionData<T> option, @Nullable String value) {
        Object parsedValue;
        if (value == null) {
            parsedValue = option.defaultValue;
        } else {
            try {
                parsedValue = option.getParser().apply(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Parse failed for option: " + option.name + ", value: " + value, e);
            }
        }
        try {
            option.getSetter().accept(parsedValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Setter invoke failed for option: " + option.name + ", value: " + String.valueOf(parsedValue), e);
        }
    }

    private static boolean parseBoolOption(String name, String val) {
        String valLower = val.trim().toLowerCase(Locale.ROOT);
        if (valLower.equals("yes") || valLower.equals("true")) {
            return true;
        }
        if (valLower.equals("no") || valLower.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Unknown value '" + val + "' for option '" + name + "', expect: 'yes' or 'no'");
    }

    private <T> OptionBuilder<T> addOption(OptionBuilder<T> optionData) {
        this.options.add((OptionData)optionData);
        return optionData;
    }

    protected static class OptionData<T>
    implements OptionDescription,
    OptionBuilder<T> {
        private final String name;
        private String desc;
        private List<T> values = Collections.emptyList();
        private OptionType type = OptionType.STRING;
        private Set<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        private Function<String, T> parser;
        private Function<T, String> formatter;
        private Consumer<T> setter;
        private T defaultValue;

        public OptionData(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.desc;
        }

        @Override
        public List<String> values() {
            return this.values.stream().map(this.formatter).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public String defaultValue() {
            return this.formatter.apply(this.defaultValue);
        }

        @Override
        public OptionType getType() {
            return this.type;
        }

        @Override
        public Set<OptionFlag> getFlags() {
            return this.flags;
        }

        @Override
        public OptionBuilder<T> description(String desc) {
            this.desc = desc;
            return this;
        }

        @Override
        public OptionBuilder<T> defaultValue(@Nullable T defValue) {
            this.defaultValue = defValue;
            return this;
        }

        @Override
        public OptionBuilder<T> parser(Function<String, T> parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public OptionBuilder<T> formatter(Function<T, String> formatter) {
            this.formatter = formatter;
            return this;
        }

        @Override
        public OptionBuilder<T> setter(Consumer<T> setter) {
            this.setter = setter;
            return this;
        }

        @Override
        public OptionBuilder<T> type(OptionType optionType) {
            this.type = optionType;
            return this;
        }

        @Override
        public OptionBuilder<T> flags(OptionFlag ... flags) {
            this.flags = EnumSet.copyOf(Arrays.asList(flags));
            return this;
        }

        @Override
        public OptionBuilder<T> values(List<T> values) {
            this.values = values;
            return this;
        }

        public Function<String, T> getParser() {
            return this.parser;
        }

        public Function<T, String> getFormatter() {
            return this.formatter;
        }

        public Consumer<T> getSetter() {
            return this.setter;
        }

        public void validate() {
            if (this.desc == null || this.desc.isEmpty()) {
                throw new IllegalArgumentException("Description should be set for option: " + this.name);
            }
            if (this.parser == null) {
                throw new IllegalArgumentException("Parser should be set for option: " + this.name);
            }
            if (this.formatter == null) {
                throw new IllegalArgumentException("Formatter should be set for option: " + this.name);
            }
            if (this.setter == null) {
                throw new IllegalArgumentException("Setter should be set for option: " + this.name);
            }
        }
    }
}

