/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.plugins.CustomResourcesLoader;
import jadx.api.plugins.resources.IResContainerFactory;
import jadx.api.plugins.resources.IResTableParserProvider;
import jadx.api.plugins.resources.IResourcesLoader;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.core.utils.android.Res9patchStreamDecoder;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.BinaryXMLParser;
import jadx.core.xmlgen.IResTableParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResTableBinaryParserProvider;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader
implements IResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private final JadxDecompiler decompiler;
    private final List<IResTableParserProvider> resTableParserProviders = new ArrayList<IResTableParserProvider>();
    private final List<IResContainerFactory> resContainerFactories = new ArrayList<IResContainerFactory>();
    private BinaryXMLParser binaryXmlParser;

    ResourcesLoader(JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.resTableParserProviders.add(new ResTableBinaryParserProvider());
    }

    List<ResourceFile> load(RootNode root) {
        this.init(root);
        List<File> inputFiles = this.decompiler.getArgs().getInputFiles();
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>(inputFiles.size());
        for (File file : inputFiles) {
            this.loadFile(list, file);
        }
        return list;
    }

    private void init(RootNode root) {
        for (IResTableParserProvider resTableParserProvider : this.resTableParserProviders) {
            try {
                resTableParserProvider.init(root);
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to init res table provider: " + String.valueOf(resTableParserProvider));
            }
        }
        for (IResContainerFactory resContainerFactory : this.resContainerFactories) {
            try {
                resContainerFactory.init(root);
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Failed to init res container factory: " + String.valueOf(resContainerFactory));
            }
        }
    }

    @Override
    public void addResContainerFactory(IResContainerFactory resContainerFactory) {
        this.resContainerFactories.add(resContainerFactory);
    }

    @Override
    public void addResTableParserProvider(IResTableParserProvider resTableParserProvider) {
        this.resTableParserProviders.add(resTableParserProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T decodeStream(ResourceFile rf, ResourceDecoder<T> decoder) throws JadxException {
        try {
            IZipEntry zipEntry = rf.getZipEntry();
            if (zipEntry != null) {
                try (InputStream inputStream = zipEntry.getInputStream();){
                    T t = decoder.decode(zipEntry.getUncompressedSize(), inputStream);
                    return t;
                }
            }
            File file = new File(rf.getOriginalName());
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                T t = decoder.decode(file.length(), inputStream);
                return t;
            }
        }
        catch (Exception e) {
            throw new JadxException("Error decode: " + rf.getOriginalName(), e);
        }
    }

    static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf) {
        try {
            ResourcesLoader resLoader = jadxRef.getResourcesLoader();
            return ResourcesLoader.decodeStream(rf, (size, is) -> resLoader.loadContent(rf, is));
        }
        catch (JadxException e) {
            LOG.error("Decode error", (Throwable)e);
            ICodeWriter cw = jadxRef.getRoot().makeCodeWriter();
            cw.add("Error decode ").add(rf.getType().toString().toLowerCase());
            Utils.appendStackTrace(cw, e.getCause());
            return ResContainer.textResource(rf.getDeobfName(), cw.finish());
        }
    }

    private ResContainer loadContent(ResourceFile resFile, InputStream inputStream) throws IOException {
        for (IResContainerFactory customFactory : this.resContainerFactories) {
            ResContainer resContainer = customFactory.create(resFile, inputStream);
            if (resContainer == null) continue;
            return resContainer;
        }
        switch (resFile.getType()) {
            case MANIFEST: 
            case XML: {
                ICodeInfo content = this.loadBinaryXmlParser().parse(inputStream);
                return ResContainer.textResource(resFile.getDeobfName(), content);
            }
            case ARSC: {
                return this.decodeTable(resFile, inputStream).decodeFiles();
            }
            case IMG: {
                return ResourcesLoader.decodeImage(resFile, inputStream);
            }
        }
        return ResContainer.resourceFileLink(resFile);
    }

    public IResTableParser decodeTable(ResourceFile resFile, InputStream is) throws IOException {
        IResTableParserProvider provider;
        if (resFile.getType() != ResourceType.ARSC) {
            throw new IllegalArgumentException("Unexpected resource type for decode: " + String.valueOf((Object)resFile.getType()) + ", expect '.pb'/'.arsc'");
        }
        IResTableParser parser = null;
        Iterator<IResTableParserProvider> iterator = this.resTableParserProviders.iterator();
        while (iterator.hasNext() && (parser = (provider = iterator.next()).getParser(resFile)) == null) {
        }
        if (parser == null) {
            throw new JadxRuntimeException("Unknown type of resource file: " + resFile.getOriginalName());
        }
        parser.setBaseFileName(resFile.getDeobfName());
        parser.decode(is);
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResContainer decodeImage(ResourceFile rf, InputStream inputStream) {
        String name = rf.getDeobfName();
        if (!name.endsWith(".9.png")) return ResContainer.resourceFileLink(rf);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Res9patchStreamDecoder decoder = new Res9patchStreamDecoder();
            if (!decoder.decode(inputStream, os)) return ResContainer.resourceFileLink(rf);
            ResContainer resContainer = ResContainer.decodedData(rf.getDeobfName(), os.toByteArray());
            return resContainer;
        }
        catch (Exception e) {
            LOG.error("Failed to decode 9-patch png image, path: {}", (Object)name, (Object)e);
        }
        return ResContainer.resourceFileLink(rf);
    }

    private void loadFile(List<ResourceFile> list, File file) {
        if (file == null || file.isDirectory()) {
            return;
        }
        for (CustomResourcesLoader loader : this.decompiler.getCustomResourcesLoaders()) {
            if (!loader.load(this, list, file)) continue;
            LOG.debug("Custom loader used for {}", (Object)file.getAbsolutePath());
            return;
        }
        this.defaultLoadFile(list, file, "");
    }

    public void defaultLoadFile(List<ResourceFile> list, File file, String subDir) {
        if (FileUtils.isZipFile(file)) {
            try {
                ZipContent zipContent = this.decompiler.getZipReader().open(file);
                this.decompiler.addCloseable((Closeable)zipContent);
                for (IZipEntry entry : zipContent.getEntries()) {
                    this.addEntry(list, file, entry, subDir);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open zip file: " + file.getAbsolutePath(), e);
            }
        } else {
            ResourceType type = ResourceType.getFileType(file.getAbsolutePath());
            list.add(ResourceFile.createResourceFile(this.decompiler, file, type));
        }
    }

    public void addEntry(List<ResourceFile> list, File zipFile, IZipEntry entry, String subDir) {
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceType type = ResourceType.getFileType(name);
        ResourceFile rf = ResourceFile.createResourceFile(this.decompiler, subDir + name, type);
        if (rf != null) {
            rf.setZipEntry(entry);
            list.add(rf);
        }
    }

    public static ICodeInfo loadToCodeWriter(InputStream is) throws IOException {
        return ResourcesLoader.loadToCodeWriter(is, StandardCharsets.UTF_8);
    }

    public static ICodeInfo loadToCodeWriter(InputStream is, Charset charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        FileUtils.copyStream(is, baos);
        return new SimpleCodeInfo(baos.toString(charset));
    }

    private synchronized BinaryXMLParser loadBinaryXmlParser() {
        if (this.binaryXmlParser == null) {
            this.binaryXmlParser = new BinaryXMLParser(this.decompiler.getRoot());
        }
        return this.binaryXmlParser;
    }

    public static interface ResourceDecoder<T> {
        public T decode(long var1, InputStream var3) throws IOException;
    }
}

