/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.dex.visitors.typeinference.TypeUpdateInfo;
import org.jetbrains.annotations.Nullable;

public final class TypeBoundCheckCastAssign
implements ITypeBoundDynamic {
    private final RootNode root;
    private final IndexInsnNode insn;

    public TypeBoundCheckCastAssign(RootNode root, IndexInsnNode insn) {
        this.root = root;
        this.insn = insn;
    }

    @Override
    public BoundEnum getBound() {
        return BoundEnum.ASSIGN;
    }

    @Override
    public ArgType getType(TypeUpdateInfo updateInfo) {
        return this.getReturnType(updateInfo.getType(this.insn.getArg(0)));
    }

    @Override
    public ArgType getType() {
        return this.getReturnType(this.insn.getArg(0).getType());
    }

    private ArgType getReturnType(ArgType argType) {
        ArgType castType = this.insn.getIndexAsType();
        TypeCompareEnum result = this.root.getTypeCompare().compareTypes(argType, castType);
        return result.isNarrow() ? argType : castType;
    }

    @Override
    @Nullable
    public RegisterArg getArg() {
        return this.insn.getResult();
    }

    public IndexInsnNode getInsn() {
        return this.insn;
    }

    public String toString() {
        return "CHECK_CAST_ASSIGN{(" + this.insn.getIndex() + ") " + this.insn.getArg(0).getType() + "}";
    }
}

