/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.ExceptionsAttr;
import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspMethod;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodThrowsAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.RegionMakerVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="MethodThrowsVisitor", desc="Scan methods to collect thrown exceptions", runAfter={RegionMakerVisitor.class})
public class MethodThrowsVisitor
extends AbstractVisitor {
    private RootNode root;

    @Override
    public void init(RootNode root) throws JadxException {
        this.root = root;
    }

    @Override
    public void visit(MethodNode mth) throws JadxException {
        MethodThrowsAttr attr = mth.get(AType.METHOD_THROWS);
        if (attr == null) {
            attr = new MethodThrowsAttr(new HashSet<String>());
            mth.addAttr((IJadxAttribute)attr);
        }
        if (!attr.isVisited()) {
            attr.setVisited(true);
            this.processInstructions(mth);
        }
        ArrayList<ArgType> invalid = new ArrayList<ArgType>();
        ExceptionsAttr exceptions = (ExceptionsAttr)mth.get(JadxAttrType.EXCEPTIONS);
        if (exceptions != null && !exceptions.getList().isEmpty()) {
            for (String throwsTypeStr : exceptions.getList()) {
                ArgType excType = ArgType.object(throwsTypeStr);
                if (this.validateException(excType) == ExceptionType.NO_EXCEPTION) {
                    invalid.add(excType);
                    continue;
                }
                attr.getList().add(excType.getObject());
            }
        }
        if (!invalid.isEmpty()) {
            mth.addWarnComment("Byte code manipulation detected: skipped illegal throws declarations: " + invalid);
        }
        this.mergeExceptions(attr.getList());
    }

    private void mergeExceptions(Set<String> excSet) {
        if (excSet.contains("java.lang.Exception")) {
            excSet.removeIf(e -> !e.equals("java.lang.Exception"));
            return;
        }
        if (excSet.contains("java.lang.Throwable")) {
            excSet.removeIf(e -> !e.equals("java.lang.Throwable"));
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String ex1 : excSet) {
            for (String ex2 : excSet) {
                if (ex1.equals(ex2) || !this.isBaseException(ex1, ex2)) continue;
                toRemove.add(ex1);
            }
        }
        toRemove.forEach(excSet::remove);
    }

    private void processInstructions(MethodNode mth) {
        if (mth.isNoCode() || mth.getBasicBlocks() == null) {
            return;
        }
        try {
            block2: for (BlockNode block : mth.getBasicBlocks()) {
                boolean skipExceptions = block.contains(AFlag.REMOVE) || block.contains(AFlag.DONT_GENERATE);
                HashSet<String> excludedExceptions = new HashSet<String>();
                CatchAttr catchAttr = block.get(AType.EXC_CATCH);
                if (catchAttr != null) {
                    for (ExceptionHandler handler : catchAttr.getHandlers()) {
                        if (handler.isCatchAll()) continue block2;
                        excludedExceptions.add(handler.getArgType().toString());
                    }
                }
                for (InsnNode insn : block.getInstructions()) {
                    this.checkInsn(mth, insn, excludedExceptions, skipExceptions);
                }
            }
        }
        catch (Exception e) {
            mth.addWarnComment("Failed to analyze thrown exceptions", e);
        }
    }

    private void checkInsn(MethodNode mth, InsnNode insn, Set<String> excludedExceptions, boolean skipExceptions) throws JadxException {
        if (!skipExceptions && insn.getType() == InsnType.THROW && !insn.contains(AFlag.DONT_GENERATE)) {
            InsnArg throwArg = insn.getArg(0);
            if (throwArg instanceof RegisterArg) {
                InsnNode assignInsn;
                RegisterArg regArg = (RegisterArg)throwArg;
                ArgType exceptionType = regArg.getType();
                if (exceptionType.equals(ArgType.THROWABLE) && (assignInsn = regArg.getAssignInsn()) != null && assignInsn.getType() == InsnType.MOVE_EXCEPTION && assignInsn.getResult().contains(AFlag.CUSTOM_DECLARE)) {
                    return;
                }
                this.visitThrows(mth, exceptionType);
            } else if (throwArg instanceof InsnWrapArg) {
                InsnWrapArg insnWrapArg = (InsnWrapArg)throwArg;
                ArgType exceptionType = insnWrapArg.getType();
                this.visitThrows(mth, exceptionType);
            }
            return;
        }
        if (insn.getType() == InsnType.INVOKE) {
            InvokeNode invokeNode = (InvokeNode)insn;
            MethodInfo callMth = invokeNode.getCallMth();
            String signature = callMth.makeSignature(true);
            ClassInfo classInfo = callMth.getDeclClass();
            ClassNode classNode = this.root.resolveClass(classInfo);
            if (classNode != null) {
                MethodNode cMth = this.searchOverriddenMethod(classNode, callMth, signature);
                if (cMth == null) {
                    return;
                }
                this.visit(cMth);
                MethodThrowsAttr cAttr = cMth.get(AType.METHOD_THROWS);
                MethodThrowsAttr attr = mth.get(AType.METHOD_THROWS);
                if (attr != null && cAttr != null && !cAttr.getList().isEmpty()) {
                    attr.getList().addAll(this.filterExceptions(cAttr.getList(), excludedExceptions));
                }
            } else {
                MethodThrowsAttr attr;
                ClspMethod cMth;
                ClspClass clsDetails = this.root.getClsp().getClsDetails(classInfo.getType());
                if (clsDetails != null && (cMth = this.searchOverriddenMethod(clsDetails, signature)) != null && cMth.getThrows() != null && !cMth.getThrows().isEmpty() && (attr = mth.get(AType.METHOD_THROWS)) != null) {
                    for (ArgType ex : cMth.getThrows()) {
                        attr.getList().add(ex.getObject());
                    }
                }
            }
        }
    }

    private void visitThrows(MethodNode mth, ArgType excType) {
        if (excType.isTypeKnown() && this.isThrowsRequired(mth, excType)) {
            mth.get(AType.METHOD_THROWS).getList().add(excType.getObject());
        }
    }

    private boolean isThrowsRequired(MethodNode mth, ArgType type) {
        ExceptionType result = this.validateException(type);
        if (result == ExceptionType.UNKNOWN_TYPE) {
            mth.addInfoComment("Thrown type has an unknown type hierarchy: " + type);
            return true;
        }
        return result == ExceptionType.THROWS_REQUIRED;
    }

    private ExceptionType validateException(ArgType clsType) {
        if (clsType == null || clsType.equals(ArgType.OBJECT)) {
            return ExceptionType.NO_EXCEPTION;
        }
        if (!clsType.isTypeKnown() || !this.root.getClsp().isClsKnown(clsType.getObject())) {
            return ExceptionType.UNKNOWN_TYPE;
        }
        if (this.isImplements(clsType, ArgType.RUNTIME_EXCEPTION) || this.isImplements(clsType, ArgType.ERROR)) {
            return ExceptionType.RUNTIME;
        }
        if (this.isImplements(clsType, ArgType.THROWABLE) || this.isImplements(clsType, ArgType.EXCEPTION)) {
            return ExceptionType.THROWS_REQUIRED;
        }
        return ExceptionType.NO_EXCEPTION;
    }

    private boolean isBaseException(String exception, String possibleParent) {
        if (exception.equals(possibleParent)) {
            return true;
        }
        return this.root.getClsp().isImplements(exception, possibleParent);
    }

    private boolean isImplements(ArgType type, ArgType baseType) {
        if (type.equals(baseType)) {
            return true;
        }
        return this.root.getClsp().isImplements(type.getObject(), baseType.getObject());
    }

    private Collection<String> filterExceptions(Set<String> exceptions, Set<String> excludedExceptions) {
        HashSet<String> filteredExceptions = new HashSet<String>();
        for (String exception : exceptions) {
            String excluded;
            boolean filtered = false;
            Iterator<String> iterator = excludedExceptions.iterator();
            while (iterator.hasNext() && !(filtered = exception.equals(excluded = iterator.next()) || this.isBaseException(exception, excluded))) {
            }
            if (filtered) continue;
            filteredExceptions.add(exception);
        }
        return filteredExceptions;
    }

    @Nullable
    private MethodNode searchOverriddenMethod(ClassNode cls, MethodInfo mth, String signature) {
        String shortId = mth.getShortId();
        for (MethodNode supMth : cls.getMethods()) {
            if (!supMth.getMethodInfo().getShortId().equals(shortId)) continue;
            return supMth;
        }
        for (MethodNode supMth : cls.getMethods()) {
            ArgType mthRetType;
            ArgType supRetType;
            TypeCompare typeCompare;
            TypeCompareEnum res;
            if (!supMth.getMethodInfo().getShortId().startsWith(signature) || supMth.getAccessFlags().isStatic() || !(res = (typeCompare = cls.root().getTypeCompare()).compareTypes(supRetType = supMth.getMethodInfo().getReturnType(), mthRetType = mth.getReturnType())).isWider()) continue;
            return supMth;
        }
        return null;
    }

    private ClspMethod searchOverriddenMethod(ClspClass clsDetails, String signature) {
        Map<String, ClspMethod> methodsMap = clsDetails.getMethodsMap();
        for (Map.Entry<String, ClspMethod> entry : methodsMap.entrySet()) {
            String mthShortId = entry.getKey();
            if (!mthShortId.startsWith(signature)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static enum ExceptionType {
        THROWS_REQUIRED,
        RUNTIME,
        UNKNOWN_TYPE,
        NO_EXCEPTION;

    }
}

