/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.utils;

import jadx.core.clsp.ClspClass;
import jadx.core.clsp.ClspMethod;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.MethodBridgeAttr;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private final RootNode root;

    public MethodUtils(RootNode rootNode) {
        this.root = rootNode;
    }

    @Nullable
    public IMethodDetails getMethodDetails(BaseInvokeNode invokeNode) {
        IMethodDetails methodDetails = invokeNode.get(AType.METHOD_DETAILS);
        if (methodDetails != null) {
            return methodDetails;
        }
        return this.getMethodDetails(invokeNode.getCallMth());
    }

    @Nullable
    public IMethodDetails getMethodDetails(MethodInfo callMth) {
        MethodNode mthNode = this.root.resolveMethod(callMth);
        if (mthNode != null) {
            return mthNode;
        }
        return this.root.getClsp().getMethodDetails(callMth);
    }

    @Nullable
    public MethodNode resolveMethod(BaseInvokeNode invokeNode) {
        IMethodDetails methodDetails = this.getMethodDetails(invokeNode);
        if (methodDetails instanceof MethodNode) {
            return (MethodNode)methodDetails;
        }
        return null;
    }

    public boolean isSkipArg(BaseInvokeNode invokeNode, InsnArg arg) {
        MethodNode mth = this.resolveMethod(invokeNode);
        if (mth == null) {
            return false;
        }
        SkipMethodArgsAttr skipArgsAttr = mth.get(AType.SKIP_MTH_ARGS);
        if (skipArgsAttr == null) {
            return false;
        }
        int argIndex = invokeNode.getArgIndex(arg);
        return skipArgsAttr.isSkip(argIndex);
    }

    public boolean isMethodArgsOverloaded(ArgType startCls, MethodInfo mthInfo) {
        return this.processMethodArgsOverloaded(startCls, mthInfo, null);
    }

    public List<IMethodDetails> collectOverloadedMethods(ArgType startCls, MethodInfo mthInfo) {
        ArrayList<IMethodDetails> list = new ArrayList<IMethodDetails>();
        this.processMethodArgsOverloaded(startCls, mthInfo, list);
        return list;
    }

    @Nullable
    public ArgType getMethodGenericReturnType(BaseInvokeNode invokeNode) {
        ArgType returnType;
        IMethodDetails methodDetails = this.getMethodDetails(invokeNode);
        if (methodDetails != null && (returnType = methodDetails.getReturnType()) != null && returnType.containsGeneric()) {
            return returnType;
        }
        return null;
    }

    private boolean processMethodArgsOverloaded(ArgType startCls, MethodInfo mthInfo, @Nullable List<IMethodDetails> collectedMths) {
        block11: {
            boolean isMthConstructor;
            block10: {
                if (startCls == null || !startCls.isObject()) {
                    return false;
                }
                isMthConstructor = mthInfo.isConstructor() || mthInfo.isClassInit();
                ClassNode classNode = this.root.resolveClass(startCls);
                if (classNode == null) break block10;
                for (MethodNode mth : classNode.getMethods()) {
                    if (!mthInfo.isOverloadedBy(mth.getMethodInfo())) continue;
                    if (collectedMths == null) {
                        return true;
                    }
                    collectedMths.add(mth);
                }
                if (isMthConstructor) break block11;
                if (this.processMethodArgsOverloaded(classNode.getSuperClass(), mthInfo, collectedMths) && collectedMths == null) {
                    return true;
                }
                for (ArgType parentInterface : classNode.getInterfaces()) {
                    if (!this.processMethodArgsOverloaded(parentInterface, mthInfo, collectedMths) || collectedMths != null) continue;
                    return true;
                }
                break block11;
            }
            ClspClass clsDetails = this.root.getClsp().getClsDetails(startCls);
            if (clsDetails == null) {
                return false;
            }
            for (ClspMethod clspMth : clsDetails.getMethodsMap().values()) {
                if (!mthInfo.isOverloadedBy(clspMth.getMethodInfo())) continue;
                if (collectedMths == null) {
                    return true;
                }
                collectedMths.add(clspMth);
            }
            if (!isMthConstructor) {
                for (ArgType parent : clsDetails.getParents()) {
                    if (!this.processMethodArgsOverloaded(parent, mthInfo, collectedMths) || collectedMths != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public IMethodDetails getOverrideBaseMth(MethodNode mth) {
        MethodOverrideAttr overrideAttr = mth.get(AType.METHOD_OVERRIDE);
        if (overrideAttr == null) {
            return null;
        }
        return Utils.getOne(overrideAttr.getBaseMethods());
    }

    public ClassInfo getMethodOriginDeclClass(MethodNode mth) {
        IMethodDetails baseMth = this.getOverrideBaseMth(mth);
        if (baseMth != null) {
            return baseMth.getMethodInfo().getDeclClass();
        }
        MethodBridgeAttr bridgeAttr = mth.get(AType.BRIDGED_BY);
        if (bridgeAttr != null) {
            return this.getMethodOriginDeclClass(bridgeAttr.getBridgeMth());
        }
        return mth.getMethodInfo().getDeclClass();
    }
}

