/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.invokedynamic.CustomLambdaCall;
import jadx.core.dex.instructions.invokedynamic.CustomRawCall;
import jadx.core.dex.instructions.invokedynamic.CustomStringConcat;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.input.InsnDataUtils;
import java.util.List;

public class InvokeCustomBuilder {
    /*
     * Loose catch block
     */
    public static InsnNode build(MethodNode mth, InsnData insn, boolean isRange) {
        List values;
        block7: {
            ICallSite callSite = InsnDataUtils.getCallSite(insn);
            if (callSite == null) {
                throw new JadxRuntimeException("Failed to get call site for insn: " + insn);
            }
            callSite.load();
            values = callSite.getValues();
            if (CustomLambdaCall.isLambdaInvoke(values)) {
                return CustomLambdaCall.buildLambdaMethodCall(mth, insn, isRange, values);
            }
            if (!CustomStringConcat.isStringConcat(values)) break block7;
            return CustomStringConcat.buildStringConcat(insn, isRange, values);
            {
                catch (Exception e) {
                    throw new JadxRuntimeException("'invoke-custom' instruction processing error: " + e.getMessage(), e);
                }
            }
        }
        try {
            return CustomRawCall.build(mth, insn, isRange, values);
        }
        catch (Exception e) {
            mth.addWarn("Failed to decode invoke-custom: \n" + Utils.listToString(values, "\n") + ",\n exception: " + Utils.getStackTrace(e));
            InsnNode nop = new InsnNode(InsnType.NOP, 0);
            nop.add(AFlag.SYNTHETIC);
            nop.addAttr(AType.JADX_ERROR, new JadxError("Failed to decode invoke-custom: " + values, e));
            return nop;
        }
    }
}

