/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf.conditions;

import jadx.api.deobf.IDeobfCondition;
import jadx.core.deobf.conditions.AbstractDeobfCondition;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;

public class ExcludeAndroidRClass
extends AbstractDeobfCondition {
    @Override
    public IDeobfCondition.Action check(ClassNode cls) {
        if (ExcludeAndroidRClass.isR(cls.getTopParentClass())) {
            return IDeobfCondition.Action.FORBID_RENAME;
        }
        return IDeobfCondition.Action.NO_ACTION;
    }

    private static boolean isR(ClassNode cls) {
        if (cls.contains(AFlag.ANDROID_R_CLASS)) {
            return true;
        }
        if (!cls.getClassInfo().getShortName().equals("R")) {
            return false;
        }
        if (!cls.getMethods().isEmpty() || !cls.getFields().isEmpty()) {
            return false;
        }
        for (ClassNode inner : cls.getInnerClasses()) {
            for (MethodNode m : inner.getMethods()) {
                if (m.getMethodInfo().isConstructor() || m.getMethodInfo().isClassInit()) continue;
                return false;
            }
            for (FieldNode field : cls.getFields()) {
                ArgType type = field.getType();
                if (type == ArgType.INT || type.isArray() && type.getArrayElement() == ArgType.INT) continue;
                return false;
            }
        }
        cls.add(AFlag.ANDROID_R_CLASS);
        return true;
    }
}

