/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CommentsLevel;
import jadx.api.ICodeWriter;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.clsp.ClspClass;
import jadx.core.codegen.ConditionGen;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.MethodGen;
import jadx.core.codegen.TypeGen;
import jadx.core.codegen.utils.CodeGenUtils;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.attributes.nodes.ForceReturnAttr;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.TryCatchRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.regions.loops.ForEachLoop;
import jadx.core.dex.regions.loops.ForLoop;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionGen
extends InsnGen {
    private static final Logger LOG = LoggerFactory.getLogger(RegionGen.class);

    public RegionGen(MethodGen mgen) {
        super(mgen, false);
    }

    public void makeRegion(ICodeWriter code, IContainer cont) throws CodegenException {
        this.declareVars(code, cont);
        cont.generate(this, code);
    }

    private void declareVars(ICodeWriter code, IContainer cont) {
        DeclareVariablesAttr declVars = cont.get(AType.DECLARE_VARIABLES);
        if (declVars != null) {
            for (CodeVar v : declVars.getVars()) {
                code.startLine();
                this.declareVar(code, v);
                code.add(';');
                CodeGenUtils.addCodeComments(code, this.mth, v.getAnySsaVar().getAssign());
            }
        }
    }

    private void makeRegionIndent(ICodeWriter code, IContainer region) throws CodegenException {
        code.incIndent();
        this.makeRegion(code, region);
        code.decIndent();
    }

    public void makeSimpleBlock(IBlock block, ICodeWriter code) throws CodegenException {
        if (block.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        for (InsnNode insn : block.getInstructions()) {
            if (insn.contains(AFlag.DONT_GENERATE)) continue;
            this.makeInsn(insn, code);
        }
        ForceReturnAttr retAttr = block.get(AType.FORCE_RETURN);
        if (retAttr != null) {
            this.makeInsn(retAttr.getReturnInsn(), code);
        }
    }

    public void makeIf(IfRegion region, ICodeWriter code, boolean newLine) throws CodegenException {
        List<BlockNode> conditionBlocks;
        if (newLine) {
            code.startLineWithNum(region.getSourceLine());
        } else {
            code.attachSourceLine(region.getSourceLine());
        }
        boolean comment = region.contains(AFlag.COMMENT_OUT);
        if (comment) {
            code.add("// ");
        }
        code.add("if (");
        new ConditionGen(this).add(code, region.getCondition());
        code.add(") {");
        if (code.isMetadataSupported() && !(conditionBlocks = region.getConditionBlocks()).isEmpty()) {
            BlockNode blockNode = conditionBlocks.get(0);
            InsnNode lastInsn = BlockUtils.getLastInsn(blockNode);
            InsnCodeOffset.attach(code, lastInsn);
            CodeGenUtils.addCodeComments(code, this.mth, lastInsn);
        }
        this.makeRegionIndent(code, region.getThenRegion());
        if (comment) {
            code.startLine("// }");
        } else {
            code.startLine('}');
        }
        IContainer els = region.getElseRegion();
        if (RegionUtils.notEmpty(els)) {
            code.add(" else ");
            if (this.connectElseIf(code, els)) {
                return;
            }
            code.add('{');
            this.makeRegionIndent(code, els);
            if (comment) {
                code.startLine("// }");
            } else {
                code.startLine('}');
            }
        }
    }

    private boolean connectElseIf(ICodeWriter code, IContainer els) throws CodegenException {
        IContainer elseBlock;
        if (els.contains(AFlag.ELSE_IF_CHAIN) && (elseBlock = RegionUtils.getSingleSubBlock(els)) instanceof IfRegion) {
            this.declareVars(code, elseBlock);
            this.makeIf((IfRegion)elseBlock, code, false);
            return true;
        }
        return false;
    }

    public void makeLoop(LoopRegion region, ICodeWriter code) throws CodegenException {
        IfCondition condition;
        code.startLineWithNum(region.getSourceLine());
        LoopLabelAttr labelAttr = region.getInfo().getStart().get(AType.LOOP_LABEL);
        if (labelAttr != null) {
            code.add(this.mgen.getNameGen().getLoopLabel(labelAttr)).add(": ");
        }
        if ((condition = region.getCondition()) == null) {
            code.add("while (true) {");
            this.makeRegionIndent(code, region.getBody());
            code.startLine('}');
            return;
        }
        InsnNode condInsn = condition.getFirstInsn();
        InsnCodeOffset.attach(code, condInsn);
        ConditionGen conditionGen = new ConditionGen(this);
        LoopType type = region.getType();
        if (type != null) {
            if (type instanceof ForLoop) {
                ForLoop forLoop = (ForLoop)type;
                code.add("for (");
                this.makeInsn(forLoop.getInitInsn(), code, InsnGen.Flags.INLINE);
                code.add("; ");
                conditionGen.add(code, condition);
                code.add("; ");
                this.makeInsn(forLoop.getIncrInsn(), code, InsnGen.Flags.INLINE);
                code.add(") {");
                CodeGenUtils.addCodeComments(code, this.mth, condInsn);
                this.makeRegionIndent(code, region.getBody());
                code.startLine('}');
                return;
            }
            if (type instanceof ForEachLoop) {
                ForEachLoop forEachLoop = (ForEachLoop)type;
                code.add("for (");
                this.declareVar(code, forEachLoop.getVarArg());
                code.add(" : ");
                this.addArg(code, forEachLoop.getIterableArg(), false);
                code.add(") {");
                CodeGenUtils.addCodeComments(code, this.mth, condInsn);
                this.makeRegionIndent(code, region.getBody());
                code.startLine('}');
                return;
            }
            throw new JadxRuntimeException("Unknown loop type: " + type.getClass());
        }
        if (region.isConditionAtEnd()) {
            code.add("do {");
            CodeGenUtils.addCodeComments(code, this.mth, condInsn);
            this.makeRegionIndent(code, region.getBody());
            code.startLineWithNum(region.getSourceLine());
            code.add("} while (");
            conditionGen.add(code, condition);
            code.add(");");
        } else {
            code.add("while (");
            conditionGen.add(code, condition);
            code.add(") {");
            CodeGenUtils.addCodeComments(code, this.mth, condInsn);
            this.makeRegionIndent(code, region.getBody());
            code.startLine('}');
        }
    }

    public void makeSynchronizedRegion(SynchronizedRegion cont, ICodeWriter code) throws CodegenException {
        code.startLine("synchronized (");
        InsnNode monitorEnterInsn = cont.getEnterInsn();
        this.addArg(code, monitorEnterInsn.getArg(0));
        code.add(") {");
        InsnCodeOffset.attach(code, monitorEnterInsn);
        CodeGenUtils.addCodeComments(code, this.mth, monitorEnterInsn);
        this.makeRegionIndent(code, cont.getRegion());
        code.startLine('}');
    }

    public void makeSwitch(SwitchRegion sw, ICodeWriter code) throws CodegenException {
        SwitchInsn insn = (SwitchInsn)BlockUtils.getLastInsn(sw.getHeader());
        Objects.requireNonNull(insn, "Switch insn not found in header");
        InsnArg arg = insn.getArg(0);
        code.startLine("switch (");
        this.addArg(code, arg, false);
        code.add(") {");
        InsnCodeOffset.attach(code, insn);
        CodeGenUtils.addCodeComments(code, this.mth, insn);
        code.incIndent();
        for (SwitchRegion.CaseInfo caseInfo : sw.getCases()) {
            List<Object> keys = caseInfo.getKeys();
            IContainer c = caseInfo.getContainer();
            for (Object k : keys) {
                if (k == SwitchRegion.DEFAULT_CASE_KEY) {
                    code.startLine("default:");
                    continue;
                }
                code.startLine("case ");
                this.addCaseKey(code, arg, k);
                code.add(':');
            }
            this.makeRegionIndent(code, c);
        }
        code.decIndent();
        code.startLine('}');
    }

    private void addCaseKey(ICodeWriter code, InsnArg arg, Object k) throws CodegenException {
        if (k instanceof FieldNode) {
            FieldNode fld = (FieldNode)k;
            this.useField(code, fld.getFieldInfo(), fld);
        } else if (k instanceof FieldInfo) {
            this.useField(code, (FieldInfo)k, null);
        } else if (k instanceof Integer) {
            code.add(TypeGen.literalToString(((Integer)k).intValue(), arg.getType(), this.mth, this.fallback));
        } else if (k instanceof String) {
            code.add('\"').add((String)k).add('\"');
        } else {
            throw new JadxRuntimeException("Unexpected key in switch: " + (k != null ? k.getClass() : null));
        }
    }

    private void useField(ICodeWriter code, FieldInfo fldInfo, @Nullable FieldNode fld) throws CodegenException {
        EncodedValue constVal;
        boolean isEnum;
        if (fld != null) {
            isEnum = fld.getParentClass().isEnum();
        } else {
            ClspClass clsDetails = this.root.getClsp().getClsDetails(fldInfo.getDeclClass().getType());
            boolean bl = isEnum = clsDetails != null && clsDetails.hasAccFlag(16384);
        }
        if (isEnum) {
            code.add(fldInfo.getAlias());
            return;
        }
        this.staticField(code, fldInfo);
        if (fld != null && this.mth.checkCommentsLevel(CommentsLevel.INFO) && (constVal = (EncodedValue)fld.get(JadxAttrType.CONSTANT_VALUE)) != null && constVal.getValue() != null) {
            code.add(" /* ").add(constVal.getValue().toString()).add(" */");
        }
    }

    public void makeTryCatch(TryCatchRegion region, ICodeWriter code) throws CodegenException {
        IContainer finallyRegion;
        code.startLine("try {");
        InsnNode insn = BlockUtils.getFirstInsn(Utils.first(region.getTryCatchBlock().getBlocks()));
        InsnCodeOffset.attach(code, insn);
        CodeGenUtils.addCodeComments(code, this.mth, insn);
        this.makeRegionIndent(code, region.getTryRegion());
        ExceptionHandler allHandler = null;
        for (Map.Entry<ExceptionHandler, IContainer> entry : region.getCatchRegions().entrySet()) {
            ExceptionHandler handler = entry.getKey();
            if (handler.isCatchAll()) {
                if (allHandler != null) {
                    LOG.warn("Several 'all' handlers in try/catch block in {}", (Object)this.mth);
                }
                allHandler = handler;
                continue;
            }
            this.makeCatchBlock(code, handler);
        }
        if (allHandler != null) {
            this.makeCatchBlock(code, allHandler);
        }
        if ((finallyRegion = region.getFinallyRegion()) != null) {
            code.startLine("} finally {");
            this.makeRegionIndent(code, finallyRegion);
        }
        code.startLine('}');
    }

    private void makeCatchBlock(ICodeWriter code, ExceptionHandler handler) throws CodegenException {
        IContainer region = handler.getHandlerRegion();
        if (region == null) {
            return;
        }
        code.startLine("} catch (");
        if (handler.isCatchAll()) {
            this.useClass(code, ArgType.THROWABLE);
        } else {
            Iterator<ClassInfo> it = handler.getCatchTypes().iterator();
            if (it.hasNext()) {
                this.useClass(code, it.next());
            }
            while (it.hasNext()) {
                code.add(" | ");
                this.useClass(code, it.next());
            }
        }
        code.add(' ');
        InsnArg arg = handler.getArg();
        if (arg == null) {
            code.add("unknown");
        } else if (arg instanceof RegisterArg) {
            SSAVar ssaVar = ((RegisterArg)arg).getSVar();
            if (code.isMetadataSupported()) {
                code.attachDefinition(VarNode.get(this.mth, ssaVar));
            }
            code.add(this.mgen.getNameGen().assignArg(ssaVar.getCodeVar()));
        } else if (arg instanceof NamedArg) {
            code.add(this.mgen.getNameGen().assignNamedArg((NamedArg)arg));
        } else {
            throw new JadxRuntimeException("Unexpected arg type in catch block: " + arg + ", class: " + arg.getClass().getSimpleName());
        }
        code.add(") {");
        InsnCodeOffset.attach(code, handler.getHandlerOffset());
        CodeGenUtils.addCodeComments(code, this.mth, handler.getHandlerBlock());
        this.makeRegionIndent(code, region);
    }
}

