/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.args.ResourceNameSource;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IFieldInfoRef;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.BetterName;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.IResTableParser;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResNameUtils;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResTableBinaryParser
extends CommonBinaryParser
implements IResTableParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResTableBinaryParser.class);
    private final boolean useRawResName;
    private final RootNode root;
    private ResourceStorage resStorage;
    private BinaryXMLStrings strings;
    private static final ResourceEntry STUB_ENTRY = new ResourceEntry(-1, "stub", "stub", "stub", "");

    public ResTableBinaryParser(RootNode root) {
        this(root, false);
    }

    public ResTableBinaryParser(RootNode root, boolean useRawResNames) {
        this.root = root;
        this.useRawResName = useRawResNames;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        long start = System.currentTimeMillis();
        this.is = new ParserStream(inputStream);
        this.resStorage = new ResourceStorage(this.root.getArgs().getSecurity());
        this.decodeTableChunk();
        this.resStorage.finish();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource table parsed: size: {}, time: {}ms", (Object)this.resStorage.size(), (Object)(System.currentTimeMillis() - start));
        }
    }

    @Override
    public ResContainer decodeFiles() {
        ValuesParser vp = new ValuesParser(this.strings, this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp, this.root.initManifestAttributes());
        ICodeInfo content = XmlGenUtils.makeXmlDump(this.root.makeCodeWriter(), this.resStorage);
        List<ResContainer> xmlFiles = resGen.makeResourcesXml(this.root.getArgs());
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    void decodeTableChunk() throws IOException {
        this.is.checkInt16(2, "Not a table chunk");
        this.is.checkInt16(12, "Unexpected table header size");
        this.is.readInt32();
        int pkgCount = this.is.readInt32();
        this.strings = this.parseStringPool();
        for (int i = 0; i < pkgCount; ++i) {
            this.parsePackage();
        }
    }

    private PackageChunk parsePackage() throws IOException {
        long start = this.is.getPos();
        this.is.checkInt16(512, "Not a table chunk");
        int headerSize = this.is.readInt16();
        if (headerSize < 284) {
            this.die("Package header size too small");
        }
        long size = this.is.readUInt32();
        long endPos = start + size;
        int id = this.is.readInt32();
        String name = this.is.readString16Fixed(128);
        long typeStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        long keyStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        if (headerSize >= 288) {
            this.is.readInt32();
        }
        this.is.skipToPos(start + (long)headerSize, "package header end");
        BinaryXMLStrings typeStrings = null;
        if (typeStringsOffset != 0L) {
            this.is.skipToPos(typeStringsOffset, "Expected typeStrings string pool");
            typeStrings = this.parseStringPool();
        }
        BinaryXMLStrings keyStrings = null;
        if (keyStringsOffset != 0L) {
            this.is.skipToPos(keyStringsOffset, "Expected keyStrings string pool");
            keyStrings = this.parseStringPool();
        }
        PackageChunk pkg = new PackageChunk(id, name, typeStrings, keyStrings);
        this.resStorage.setAppPackage(name);
        block9: while (this.is.getPos() < endPos) {
            long chunkStart = this.is.getPos();
            int type = this.is.readInt16();
            LOG.trace("res package chunk start at {} type {}", (Object)chunkStart, (Object)type);
            switch (type) {
                case 0: {
                    LOG.info("Null chunk type encountered at offset {}", (Object)chunkStart);
                    continue block9;
                }
                case 513: {
                    this.parseTypeChunk(chunkStart, pkg);
                    continue block9;
                }
                case 514: {
                    this.parseTypeSpecChunk(chunkStart);
                    continue block9;
                }
                case 515: {
                    this.parseLibraryTypeChunk(chunkStart);
                    continue block9;
                }
                case 516: {
                    this.parseOverlayTypeChunk(chunkStart);
                    continue block9;
                }
                case 517: {
                    throw new IOException(String.format("Encountered unsupported chunk type RES_TABLE_TYPE_OVERLAY_POLICY at offset 0x%x ", chunkStart));
                }
                case 518: {
                    this.parseStagedAliasChunk(chunkStart);
                    continue block9;
                }
            }
            LOG.warn("Unknown chunk type {} encountered at offset {}", (Object)type, (Object)chunkStart);
        }
        return pkg;
    }

    private void parseTypeSpecChunk(long chunkStart) throws IOException {
        this.is.checkInt16(16, "Unexpected type spec header size");
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        int id = this.is.readInt8();
        this.is.skip(3L);
        int entryCount = this.is.readInt32();
        for (int i = 0; i < entryCount; ++i) {
            int n = this.is.readInt32();
        }
        if (this.is.getPos() != expectedEndPos) {
            throw new IOException(String.format("Error reading type spec chunk at offset 0x%x", chunkStart));
        }
    }

    private void parseLibraryTypeChunk(long chunkStart) throws IOException {
        LOG.trace("parsing library type chunk starting at offset {}", (Object)chunkStart);
        this.is.checkInt16(12, "Unexpected header size");
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        int count = this.is.readInt32();
        for (int i = 0; i < count; ++i) {
            int packageId = this.is.readInt32();
            String packageName = this.is.readString16Fixed(128);
            LOG.info("Found resource shared library {}, pkgId: {}", (Object)packageName, (Object)packageId);
            if (this.is.getPos() <= expectedEndPos) continue;
            throw new IOException("reading after chunk end");
        }
        if (this.is.getPos() != expectedEndPos) {
            throw new IOException(String.format("Error reading library chunk at offset 0x%x", chunkStart));
        }
    }

    private void parseTypeChunk(long start, PackageChunk pkg) throws IOException {
        int offset;
        int i;
        this.is.readInt16();
        long chunkSize = this.is.readUInt32();
        long chunkEnd = start + chunkSize;
        int id = this.is.readInt8();
        int flags = this.is.readInt8();
        boolean isSparse = (flags & 1) != 0;
        boolean isOffset16 = (flags & 2) != 0;
        this.is.checkInt16(0, "type chunk, reserved");
        int entryCount = this.is.readInt32();
        long entriesStart = start + (long)this.is.readInt32();
        EntryConfig config = this.parseConfig();
        if (config.isInvalid) {
            String typeName = pkg.getTypeStrings().get(id - 1);
            LOG.warn("Invalid config flags detected: {}{}", (Object)typeName, (Object)config.getQualifiers());
        }
        ArrayList<EntryOffset> offsets = new ArrayList<EntryOffset>(entryCount);
        if (isSparse) {
            for (i = 0; i < entryCount; ++i) {
                int idx = this.is.readInt16();
                offset = this.is.readInt16() * 4;
                offsets.add(new EntryOffset(idx, offset));
            }
        } else if (isOffset16) {
            for (i = 0; i < entryCount; ++i) {
                int offset2 = this.is.readInt16();
                if (offset2 == 65535) continue;
                offsets.add(new EntryOffset(i, offset2 * 4));
            }
        } else {
            for (i = 0; i < entryCount; ++i) {
                offsets.add(new EntryOffset(i, this.is.readInt32()));
            }
        }
        this.is.skipToPos(entriesStart, "Failed to skip to entries start");
        for (EntryOffset entryOffset : offsets) {
            offset = entryOffset.getOffset();
            if (offset == -1) continue;
            int index = entryOffset.getIdx();
            if (this.is.getPos() >= chunkEnd) {
                LOG.warn("End of chunk reached - ignoring remaining {} entries", (Object)(entryCount - index));
                break;
            }
            this.is.checkPos(entriesStart + (long)offset, "Expected start of entry " + index);
            this.parseEntry(pkg, id, index, config.getQualifiers());
        }
        if (chunkEnd > this.is.getPos()) {
            long skipSize = chunkEnd - this.is.getPos();
            LOG.debug("Unknown data at the end of type chunk encountered, skipping {} bytes and continuing at offset {}", (Object)skipSize, (Object)chunkEnd);
            this.is.skip(skipSize);
        }
    }

    private void parseOverlayTypeChunk(long chunkStart) throws IOException {
        LOG.trace("parsing overlay type chunk starting at offset {}", (Object)chunkStart);
        this.is.readInt16();
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        String name = this.is.readString16Fixed(256);
        String actor = this.is.readString16Fixed(256);
        LOG.trace("Overlay header data: name={} actor={}", (Object)name, (Object)actor);
        this.is.skipToPos(expectedEndPos, "overlay chunk end");
    }

    private void parseStagedAliasChunk(long chunkStart) throws IOException {
        LOG.trace("parsing staged alias chunk starting at offset {}", (Object)chunkStart);
        this.is.readInt16();
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        int count = this.is.readInt32();
        for (int i = 0; i < count; ++i) {
            int stagedResId = this.is.readInt32();
            int finalizedResId = this.is.readInt32();
            LOG.debug("Staged alias: stagedResId {} finalizedResId {}", (Object)stagedResId, (Object)finalizedResId);
        }
        this.is.skipToPos(expectedEndPos, "staged alias chunk end");
    }

    private void parseEntry(PackageChunk pkg, int typeId, int entryId, String config) throws IOException {
        int key;
        int size = this.is.readInt16();
        int flags = this.is.readInt16();
        boolean isComplex = (flags & 1) != 0;
        boolean isCompact = (flags & 8) != 0;
        int n = key = isCompact ? size : this.is.readInt32();
        if (key == -1) {
            return;
        }
        int resRef = pkg.getId() << 24 | typeId << 16 | entryId;
        String typeName = pkg.getTypeStrings().get(typeId - 1);
        String origKeyName = pkg.getKeyStrings().get(key);
        ResourceEntry newResEntry = this.buildResourceEntry(pkg, config, resRef, typeName, origKeyName);
        if (isCompact) {
            int dataType = flags >> 8;
            int data = this.is.readInt32();
            newResEntry.setSimpleValue(new RawValue(dataType, data));
        } else if (isComplex || size == 16) {
            int parentRef = this.is.readInt32();
            int count = this.is.readInt32();
            newResEntry.setParentRef(parentRef);
            ArrayList<RawNamedValue> values = new ArrayList<RawNamedValue>(count);
            for (int i = 0; i < count; ++i) {
                values.add(this.parseValueMap());
            }
            newResEntry.setNamedValues(values);
        } else {
            newResEntry.setSimpleValue(this.parseValue());
        }
    }

    private ResourceEntry buildResourceEntry(PackageChunk pkg, String config, int resRef, String typeName, String origKeyName) {
        ResourceEntry newResEntry;
        if (!ZipSecurity.isValidZipEntryName(origKeyName)) {
            return STUB_ENTRY;
        }
        if (this.useRawResName) {
            newResEntry = new ResourceEntry(resRef, pkg.getName(), typeName, origKeyName, config);
        } else {
            String resName = this.getResName(resRef, origKeyName);
            newResEntry = new ResourceEntry(resRef, pkg.getName(), typeName, resName, config);
            ResourceEntry prevResEntry = this.resStorage.searchEntryWithSameName(newResEntry);
            if (prevResEntry != null) {
                newResEntry = newResEntry.copyWithId();
                ResourceEntry replaceForPrevEntry = prevResEntry.copyWithId();
                this.resStorage.replace(prevResEntry, replaceForPrevEntry);
                this.resStorage.addRename(replaceForPrevEntry);
            }
            if (!Objects.equals(origKeyName, newResEntry.getKeyName())) {
                this.resStorage.addRename(newResEntry);
            }
        }
        this.resStorage.add(newResEntry);
        return newResEntry;
    }

    private String getResName(int resRef, String origKeyName) {
        if (this.useRawResName) {
            return origKeyName;
        }
        String renamedKey = this.resStorage.getRename(resRef);
        if (renamedKey != null) {
            return renamedKey;
        }
        IFieldInfoRef fldRef = this.root.getConstValues().getGlobalConstFields().get(resRef);
        FieldNode constField = fldRef instanceof FieldNode ? (FieldNode)fldRef : null;
        String newResName = this.getNewResName(resRef, origKeyName, constField);
        if (!origKeyName.equals(newResName)) {
            this.resStorage.addRename(resRef, newResName);
        }
        if (constField != null) {
            String newFieldName = ResNameUtils.convertToRFieldName(newResName);
            constField.rename(newFieldName);
            constField.add(AFlag.DONT_RENAME);
        }
        return newResName;
    }

    private String getNewResName(int resRef, String origKeyName, @Nullable FieldNode constField) {
        String newResName = constField == null || constField.getTopParentClass().isSynthetic() ? origKeyName : ResTableBinaryParser.getBetterName(this.root.getArgs().getResourceNameSource(), origKeyName, constField.getName());
        if (this.root.getArgs().isRenameValid()) {
            boolean allowNonPrintable = !this.root.getArgs().isRenamePrintable();
            newResName = ResNameUtils.sanitizeAsResourceName(newResName, String.format("_res_0x%08x", resRef), allowNonPrintable);
        }
        return newResName;
    }

    public static String getBetterName(ResourceNameSource nameSource, String resName, String codeName) {
        switch (nameSource) {
            case AUTO: {
                return BetterName.getBetterResourceName(resName, codeName);
            }
            case RESOURCES: {
                return resName;
            }
            case CODE: {
                return codeName;
            }
        }
        throw new JadxRuntimeException("Unexpected ResourceNameSource value: " + nameSource);
    }

    private RawNamedValue parseValueMap() throws IOException {
        int nameRef = this.is.readInt32();
        return new RawNamedValue(nameRef, this.parseValue());
    }

    private RawValue parseValue() throws IOException {
        this.is.checkInt16(8, "value size");
        this.is.checkInt8(0, "value res0 not 0");
        int dataType = this.is.readInt8();
        int data = this.is.readInt32();
        return new RawValue(dataType, data);
    }

    private EntryConfig parseConfig() throws IOException {
        long start = this.is.getPos();
        int size = this.is.readInt32();
        if (size < 28) {
            throw new IOException("Config size < 28");
        }
        short mcc = (short)this.is.readInt16();
        short mnc = (short)this.is.readInt16();
        char[] language = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), 'a');
        char[] country = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), '0');
        byte orientation = (byte)this.is.readInt8();
        byte touchscreen = (byte)this.is.readInt8();
        int density = this.is.readInt16();
        byte keyboard = (byte)this.is.readInt8();
        byte navigation = (byte)this.is.readInt8();
        byte inputFlags = (byte)this.is.readInt8();
        byte grammaticalInflection = (byte)this.is.readInt8();
        short screenWidth = (short)this.is.readInt16();
        short screenHeight = (short)this.is.readInt16();
        short sdkVersion = (short)this.is.readInt16();
        this.is.readInt16();
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = (byte)this.is.readInt8();
            uiMode = (byte)this.is.readInt8();
            smallestScreenWidthDp = (short)this.is.readInt16();
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = (short)this.is.readInt16();
            screenHeightDp = (short)this.is.readInt16();
        }
        char[] localeScript = null;
        char[] localeVariant = null;
        if (size >= 48) {
            localeScript = this.readScriptOrVariantChar(4).toCharArray();
            localeVariant = this.readScriptOrVariantChar(8).toCharArray();
        }
        byte screenLayout2 = 0;
        byte colorMode = 0;
        if (size >= 52) {
            screenLayout2 = (byte)this.is.readInt8();
            colorMode = (byte)this.is.readInt8();
            this.is.readInt16();
        }
        this.is.skipToPos(start + (long)size, "Config skip trailing bytes");
        return new EntryConfig(mcc, mnc, language, country, orientation, touchscreen, density, keyboard, navigation, inputFlags, grammaticalInflection, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, false, size);
    }

    private char[] unpackLocaleOrRegion(byte in0, byte in1, char base) {
        if ((in0 >> 7 & 1) == 1) {
            int first = in1 & 0x1F;
            int second = ((in1 & 0xE0) >> 5) + ((in0 & 3) << 3);
            int third = (in0 & 0x7C) >> 2;
            return new char[]{(char)(first + base), (char)(second + base), (char)(third + base)};
        }
        return new char[]{(char)in0, (char)in1};
    }

    private String readScriptOrVariantChar(int length) throws IOException {
        short ch;
        long start = this.is.getPos();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < length && (ch = (short)this.is.readInt8()) != 0; ++i) {
            sb.append((char)ch);
        }
        this.is.skipToPos(start + (long)length, "readScriptOrVariantChar");
        return sb.toString();
    }

    @Override
    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    @Override
    public BinaryXMLStrings getStrings() {
        return this.strings;
    }

    private static class EntryOffset {
        private final int idx;
        private final int offset;

        private EntryOffset(int idx, int offset) {
            this.idx = idx;
            this.offset = offset;
        }

        public int getIdx() {
            return this.idx;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static final class PackageChunk {
        private final int id;
        private final String name;
        private final BinaryXMLStrings typeStrings;
        private final BinaryXMLStrings keyStrings;

        private PackageChunk(int id, String name, BinaryXMLStrings typeStrings, BinaryXMLStrings keyStrings) {
            this.id = id;
            this.name = name;
            this.typeStrings = typeStrings;
            this.keyStrings = keyStrings;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public BinaryXMLStrings getTypeStrings() {
            return this.typeStrings;
        }

        public BinaryXMLStrings getKeyStrings() {
            return this.keyStrings;
        }
    }
}

