/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipPatch {
    private static final Logger LOG = LoggerFactory.getLogger(ZipPatch.class);

    public static List<File> patchZipFiles(List<File> inputs) {
        ArrayList<File> result = new ArrayList<File>(inputs.size());
        for (File input : inputs) {
            try {
                result.add(ZipPatch.patchZipFile(input));
            }
            catch (Throwable e) {
                LOG.warn("Failed to patch zip file: {}", (Object)input.getAbsolutePath(), (Object)e);
                result.add(input);
            }
        }
        return result;
    }

    private static File patchZipFile(File file) throws IOException {
        List localHeaderToFix;
        String fileName = file.getPath().toLowerCase();
        if (!fileName.endsWith(".apk") && !fileName.endsWith(".zip")) {
            return file;
        }
        ArrayList<Long> cDirEntriesToFix = new ArrayList<Long>();
        ArrayList<Long> localHeaders = new ArrayList<Long>();
        try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
            long endOfCDirOffset = ZipPatch.findEndOfCentralDir(raFile);
            raFile.seek(endOfCDirOffset + 16L);
            long cDirOffset = Integer.toUnsignedLong(Integer.reverseBytes(raFile.readInt()));
            raFile.seek(endOfCDirOffset + 10L);
            long cDirNumEntries = Short.toUnsignedLong(Short.reverseBytes(raFile.readShort()));
            long off2 = cDirOffset;
            for (long i = 0L; i < cDirNumEntries; ++i) {
                HeaderInfo info = ZipPatch.readHeader(raFile, off2);
                if (!info.validCompression()) {
                    cDirEntriesToFix.add(off2);
                }
                raFile.seek(off2 + 42L);
                localHeaders.add(Integer.toUnsignedLong(Integer.reverseBytes(raFile.readInt())));
                off2 += info.dataOffset;
            }
            localHeaderToFix = localHeaders.stream().filter(off -> !ZipPatch.readHeaderVexxed(raFile, off).validCompression()).collect(Collectors.toList());
            if (cDirEntriesToFix.isEmpty() && localHeaderToFix.isEmpty()) {
                File file2 = file;
                return file2;
            }
        }
        File newFile = ZipPatch.copyFile(file);
        try (RandomAccessFile newRaFile = new RandomAccessFile(newFile, "rwd");){
            HeaderInfo info;
            for (Long off3 : cDirEntriesToFix) {
                info = ZipPatch.readHeader(newRaFile, off3);
                newRaFile.seek(off3 + 10L);
                newRaFile.writeShort(0);
                newRaFile.seek(off3 + 20L);
                newRaFile.writeInt(Integer.reverseBytes((int)info.uncompressedSize));
            }
            for (Long off4 : localHeaderToFix) {
                info = ZipPatch.readHeader(newRaFile, off4);
                newRaFile.seek(off4 + 8L);
                newRaFile.writeShort(0);
                newRaFile.seek(off4 + 18L);
                newRaFile.writeInt(Integer.reverseBytes((int)info.uncompressedSize));
                newRaFile.seek(off4 + 28L);
                newRaFile.writeShort(0);
                ZipPatch.moveBlockBack(newRaFile, off4 + info.dataOffset, info.uncompressedSize, info.extraLen);
            }
        }
        LOG.info("Input zip file patched: {}", (Object)file.getAbsolutePath());
        return newFile;
    }

    private static void moveBlockBack(RandomAccessFile file, long offset, long size, long delta) throws IOException {
        byte[] buffer = new byte[0x100000];
        while (size > 0L) {
            int len = (int)Math.min((long)buffer.length, size);
            file.seek(offset);
            file.read(buffer, 0, len);
            file.seek(offset - delta);
            file.write(buffer, 0, len);
            size -= (long)len;
            offset += (long)len;
        }
    }

    private static File copyFile(File file) throws IOException {
        File newFile = FileUtils.createTempFile(file.getName()).toFile();
        try (FileInputStream in = new FileInputStream(file);
             FileOutputStream out = new FileOutputStream(newFile);){
            in.transferTo(out);
        }
        return newFile;
    }

    private static long findEndOfCentralDir(RandomAccessFile file) throws IOException {
        long offset = file.length() - 21L + 1L;
        do {
            if (offset <= 0L) {
                throw new IllegalArgumentException("File is not a valid ZIP: End of central directory record not found");
            }
            file.seek(--offset);
        } while (Integer.reverseBytes(file.readInt()) != 101010256);
        return offset;
    }

    private static HeaderInfo readHeaderVexxed(RandomAccessFile file, long offset) {
        try {
            return ZipPatch.readHeader(file, offset);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static HeaderInfo readHeader(RandomAccessFile file, long offset) throws IOException {
        HeaderInfo info = new HeaderInfo();
        file.seek(offset);
        int signature = Integer.reverseBytes(file.readInt());
        if (signature != 33639248 && signature != 67324752) {
            throw new IllegalArgumentException(String.format("Invalid ZIP header signature %x at offset %x", signature, offset));
        }
        boolean isCentralHeader = signature == 33639248;
        int delta = isCentralHeader ? 0 : -2;
        file.seek(offset + 10L + (long)delta);
        info.compression = Short.reverseBytes(file.readShort());
        file.seek(offset + 24L + (long)delta);
        info.uncompressedSize = Integer.toUnsignedLong(Integer.reverseBytes(file.readInt()));
        file.seek(offset + 28L + (long)delta);
        long nameLen = Short.toUnsignedLong(Short.reverseBytes(file.readShort()));
        info.extraLen = Short.toUnsignedLong(Short.reverseBytes(file.readShort()));
        long commentLen = 0L;
        if (isCentralHeader) {
            commentLen = Short.toUnsignedLong(Short.reverseBytes(file.readShort()));
        }
        info.dataOffset = (long)(isCentralHeader ? 46 : 30) + nameLen + info.extraLen + commentLen;
        return info;
    }

    private static class HeaderInfo {
        short compression;
        long uncompressedSize;
        long dataOffset;
        long extraLen;

        private HeaderInfo() {
        }

        boolean validCompression() {
            return this.compression == 0 || this.compression == 8;
        }
    }
}

