/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins.files;

import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.files.FileUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempFilesGetter
implements IJadxFilesGetter {
    public static final TempFilesGetter INSTANCE = new TempFilesGetter();
    private final Path tempRootDir;

    private TempFilesGetter() {
        try {
            this.tempRootDir = Files.createTempDirectory("jadx-temp-", new FileAttribute[0]);
            this.tempRootDir.toFile().deleteOnExit();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create temp directory", e);
        }
    }

    @Override
    public Path getConfigDir() {
        return this.makeSubDir("config");
    }

    @Override
    public Path getCacheDir() {
        return this.makeSubDir("cache");
    }

    @Override
    public Path getTempDir() {
        return this.tempRootDir;
    }

    private Path makeSubDir(String subDir) {
        Path dir = this.tempRootDir.resolve(subDir);
        FileUtils.makeDirs(dir);
        return dir;
    }
}

