/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.maker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.EdgeInsnAttr;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.regions.maker.IfRegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionMaker;
import jadx.core.dex.visitors.regions.maker.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class LoopRegionMaker {
    private final MethodNode mth;
    private final RegionMaker regionMaker;
    private final IfRegionMaker ifMaker;

    LoopRegionMaker(MethodNode mth, RegionMaker regionMaker, IfRegionMaker ifMaker) {
        this.mth = mth;
        this.regionMaker = regionMaker;
        this.ifMaker = ifMaker;
    }

    BlockNode process(IRegion curRegion, LoopInfo loop, RegionStack stack) {
        Region body;
        BlockNode out;
        BlockNode loopExit;
        BlockNode loopStart = loop.getStart();
        Set<BlockNode> exitBlocksSet = loop.getExitNodes();
        ArrayList<BlockNode> exitBlocks = new ArrayList<BlockNode>(exitBlocksSet.size());
        BlockNode nextStart = BlockUtils.getNextBlock(loopStart);
        if (nextStart != null && exitBlocksSet.remove(nextStart)) {
            exitBlocks.add(nextStart);
        }
        if (exitBlocksSet.remove(loopStart)) {
            exitBlocks.add(loopStart);
        }
        if (exitBlocksSet.remove(loop.getEnd())) {
            exitBlocks.add(loop.getEnd());
        }
        exitBlocks.addAll(exitBlocksSet);
        LoopRegion loopRegion = this.makeLoopRegion(curRegion, loop, exitBlocks);
        if (loopRegion == null) {
            BlockNode exit = this.makeEndlessLoop(curRegion, stack, loop, loopStart);
            LoopRegionMaker.insertContinue(loop);
            return exit;
        }
        curRegion.getSubBlocks().add(loopRegion);
        IRegion outerRegion = stack.peekRegion();
        stack.push(loopRegion);
        IfInfo condInfo = this.ifMaker.buildIfInfo(loopRegion);
        if (!loop.getLoopBlocks().contains(condInfo.getThenBlock())) {
            condInfo = IfInfo.invert(condInfo);
        }
        loopRegion.updateCondition(condInfo);
        condInfo.getMergedBlocks().forEach(b -> b.add(AFlag.ADDED_TO_REGION));
        exitBlocks.removeAll(condInfo.getMergedBlocks());
        if (!exitBlocks.isEmpty() && (loopExit = condInfo.getElseBlock()) != null) {
            for (Edge exitEdge : loop.getExitEdges()) {
                if (!exitBlocks.contains(exitEdge.getSource())) continue;
                this.insertLoopBreak(stack, loop, loopExit, exitEdge);
            }
        }
        if (loopRegion.isConditionAtEnd()) {
            BlockNode thenBlock = condInfo.getThenBlock();
            out = thenBlock == loop.getEnd() || thenBlock == loopStart ? condInfo.getElseBlock() : thenBlock;
            out = BlockUtils.followEmptyPath(out);
            loopStart.remove(AType.LOOP);
            loop.getEnd().add(AFlag.ADDED_TO_REGION);
            stack.addExit(loop.getEnd());
            this.regionMaker.clearBlockProcessedState(loopStart);
            body = this.regionMaker.makeRegion(loopStart);
            loopRegion.setBody(body);
            loopStart.addAttr(AType.LOOP, loop);
            loop.getEnd().remove(AFlag.ADDED_TO_REGION);
        } else {
            out = condInfo.getElseBlock();
            if (outerRegion != null && out != null && out.contains(AFlag.LOOP_START) && !out.getAll(AType.LOOP).contains(loop) && RegionUtils.isRegionContainsBlock(outerRegion, out)) {
                out = null;
            }
            stack.addExit(out);
            BlockNode loopBody = condInfo.getThenBlock();
            body = Objects.equals(loopBody, loopStart) ? new Region(loopRegion) : this.regionMaker.makeRegion(loopBody);
            BlockNode conditionBlock = condInfo.getFirstIfBlock();
            if (loopStart != conditionBlock) {
                Set<BlockNode> blocks = BlockUtils.getAllPathsBlocks(loopStart, conditionBlock);
                blocks.remove(conditionBlock);
                for (BlockNode block : blocks) {
                    if (!block.getInstructions().isEmpty() || block.contains(AFlag.ADDED_TO_REGION) || RegionUtils.isRegionContainsBlock(body, block)) continue;
                    body.add(block);
                }
            }
            loopRegion.setBody(body);
        }
        stack.pop();
        LoopRegionMaker.insertContinue(loop);
        return out;
    }

    private LoopRegion makeLoopRegion(IRegion curRegion, LoopInfo loop, List<BlockNode> exitBlocks) {
        for (BlockNode block : exitBlocks) {
            List<LoopInfo> list;
            boolean found;
            List loops;
            InsnNode lastInsn;
            if (block.contains(AType.EXC_HANDLER) || (lastInsn = BlockUtils.getLastInsn(block)) == null || lastInsn.getType() != InsnType.IF || !(loops = block.getAll(AType.LOOP)).isEmpty() && loops.get(0) != loop) continue;
            boolean exitAtLoopEnd = LoopRegionMaker.isExitAtLoopEnd(block, loop);
            LoopRegion loopRegion = new LoopRegion(curRegion, loop, block, exitAtLoopEnd);
            if (block == loop.getStart() || exitAtLoopEnd || BlockUtils.isEmptySimplePath(loop.getStart(), block)) {
                found = true;
            } else if (block.getPredecessors().contains(loop.getStart())) {
                loopRegion.setPreCondition(loop.getStart());
                found = loopRegion.checkPreCondition();
            } else {
                found = false;
            }
            if (found && (list = this.mth.getAllLoopsForBlock(block)).size() >= 2) {
                boolean allOuter = true;
                for (BlockNode outerBlock : block.getCleanSuccessors()) {
                    List<LoopInfo> outLoopList = this.mth.getAllLoopsForBlock(outerBlock);
                    outLoopList.remove(loop);
                    if (outLoopList.isEmpty()) continue;
                    allOuter = false;
                    break;
                }
                if (allOuter) {
                    found = false;
                }
            }
            if (found && !this.checkLoopExits(loop, block)) {
                found = false;
            }
            if (!found) continue;
            return loopRegion;
        }
        return null;
    }

    private static boolean isExitAtLoopEnd(BlockNode exit, LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        if (exit == loopEnd) {
            return true;
        }
        BlockNode loopStart = loop.getStart();
        if (loopStart.getInstructions().isEmpty() && ListUtils.isSingleElement(loopStart.getSuccessors(), exit)) {
            return false;
        }
        return loopEnd.getInstructions().isEmpty() && ListUtils.isSingleElement(loopEnd.getPredecessors(), exit);
    }

    private boolean checkLoopExits(LoopInfo loop, BlockNode mainExitBlock) {
        List<Edge> exitEdges = loop.getExitEdges();
        if (exitEdges.size() < 2) {
            return true;
        }
        Optional<Edge> mainEdgeOpt = exitEdges.stream().filter(edge -> edge.getSource() == mainExitBlock).findFirst();
        if (mainEdgeOpt.isEmpty()) {
            throw new JadxRuntimeException("Not found exit edge by exit block: " + mainExitBlock);
        }
        Edge mainExitEdge = mainEdgeOpt.get();
        BlockNode mainOutBlock = mainExitEdge.getTarget();
        for (Edge exitEdge : exitEdges) {
            BlockNode crossBlock;
            BlockNode exitBlock;
            if (exitEdge == mainExitEdge || BlockUtils.isEqualPaths(mainOutBlock, exitBlock = exitEdge.getTarget()) || (crossBlock = BlockUtils.getPathCross(this.mth, mainOutBlock, exitBlock)) == null) continue;
            return false;
        }
        return true;
    }

    private BlockNode makeEndlessLoop(IRegion curRegion, RegionStack stack, LoopInfo loop, BlockNode loopStart) {
        LoopRegion loopRegion = new LoopRegion(curRegion, loop, null, false);
        curRegion.getSubBlocks().add(loopRegion);
        loopStart.remove(AType.LOOP);
        this.regionMaker.clearBlockProcessedState(loopStart);
        stack.push(loopRegion);
        BlockNode out = null;
        List<Edge> exitEdges = loop.getExitEdges();
        if (exitEdges.size() == 1) {
            BlockNode nextBlock;
            Edge exitEdge = exitEdges.get(0);
            BlockNode exit = exitEdge.getTarget();
            if (this.insertLoopBreak(stack, loop, exit, exitEdge) && (nextBlock = BlockUtils.getNextBlock(exit)) != null) {
                stack.addExit(nextBlock);
                out = nextBlock;
            }
        } else {
            for (Edge exitEdge : exitEdges) {
                BlockNode exit = exitEdge.getTarget();
                List<BlockNode> blocks = BlockUtils.bitSetToBlocks(this.mth, exit.getDomFrontier());
                for (BlockNode block : blocks) {
                    if (BlockUtils.isPathExists(exit, block)) {
                        stack.addExit(block);
                        this.insertLoopBreak(stack, loop, block, exitEdge);
                        out = block;
                        continue;
                    }
                    this.insertLoopBreak(stack, loop, exit, exitEdge);
                }
            }
        }
        Region body = this.regionMaker.makeRegion(loopStart);
        BlockNode loopEnd = loop.getEnd();
        if (!(RegionUtils.isRegionContainsBlock(body, loopEnd) || loopEnd.contains(AType.EXC_HANDLER) || this.inExceptionHandlerBlocks(loopEnd))) {
            body.getSubBlocks().add(loopEnd);
        }
        loopRegion.setBody(body);
        if (out == null) {
            BlockNode next = BlockUtils.getNextBlock(loopEnd);
            out = RegionUtils.isRegionContainsBlock(body, next) ? null : next;
        }
        stack.pop();
        loopStart.addAttr(AType.LOOP, loop);
        return out;
    }

    private boolean inExceptionHandlerBlocks(BlockNode loopEnd) {
        if (this.mth.getExceptionHandlersCount() == 0) {
            return false;
        }
        for (ExceptionHandler eh : this.mth.getExceptionHandlers()) {
            if (!eh.getBlocks().contains(loopEnd)) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertBreak(BlockNode exit) {
        BlockNode lastBlock;
        if (BlockUtils.containsExitInsn(exit)) {
            return false;
        }
        List<BlockNode> simplePath = BlockUtils.buildSimplePath(exit);
        if (!simplePath.isEmpty() && ((lastBlock = simplePath.get(simplePath.size() - 1)).isMthExitBlock() || lastBlock.isReturnBlock() || this.mth.isPreExitBlock(lastBlock))) {
            return false;
        }
        Set<BlockNode> paths = BlockUtils.getAllPathsBlocks(this.mth.getEnterBlock(), exit);
        for (BlockNode block : paths) {
            if (!BlockUtils.checkLastInsnType(block, InsnType.SWITCH)) continue;
            return false;
        }
        return true;
    }

    private boolean insertLoopBreak(RegionStack stack, LoopInfo loop, BlockNode loopExit, Edge exitEdge) {
        BlockNode exit = exitEdge.getTarget();
        Edge insertEdge = null;
        boolean confirm = false;
        BlockNode exitEnd = BlockUtils.followEmptyPath(exit);
        List loops = exitEnd.getAll(AType.LOOP);
        for (LoopInfo loopAtEnd : loops) {
            if (loopAtEnd == loop || !loop.hasParent(loopAtEnd)) continue;
            insertEdge = exitEdge;
            confirm = true;
            break;
        }
        if (!confirm) {
            BlockNode insertBlock = null;
            while (exit != null) {
                if (insertBlock != null && BlockUtils.isPathExists(loopExit, exit)) {
                    if (this.canInsertBreak(insertBlock)) {
                        insertEdge = new Edge(insertBlock, insertBlock.getSuccessors().get(0));
                        confirm = true;
                        break;
                    }
                    return false;
                }
                insertBlock = exit;
                List<BlockNode> cs = exit.getCleanSuccessors();
                exit = cs.size() == 1 ? cs.get(0) : null;
            }
        }
        if (!confirm) {
            return false;
        }
        InsnNode breakInsn = new InsnNode(InsnType.BREAK, 0);
        breakInsn.addAttr(AType.LOOP, loop);
        EdgeInsnAttr.addEdgeInsn(insertEdge, breakInsn);
        stack.addExit(exit);
        this.addBreakLabel(exitEdge, exit, breakInsn);
        return true;
    }

    private void addBreakLabel(Edge exitEdge, BlockNode exit, InsnNode breakInsn) {
        BlockNode outBlock = BlockUtils.getNextBlock(exitEdge.getTarget());
        if (outBlock == null) {
            return;
        }
        List<LoopInfo> exitLoop = this.mth.getAllLoopsForBlock(outBlock);
        if (!exitLoop.isEmpty()) {
            return;
        }
        List<LoopInfo> inLoops = this.mth.getAllLoopsForBlock(exitEdge.getSource());
        if (inLoops.size() < 2) {
            return;
        }
        LoopInfo parentLoop = null;
        for (LoopInfo loop : inLoops) {
            if (loop.getParentLoop() != null) continue;
            parentLoop = loop;
            break;
        }
        if (parentLoop == null) {
            return;
        }
        if (parentLoop.getEnd() != exit && !parentLoop.getExitNodes().contains(exit)) {
            LoopLabelAttr labelAttr = new LoopLabelAttr(parentLoop);
            breakInsn.addAttr(labelAttr);
            parentLoop.getStart().addAttr(labelAttr);
        }
    }

    private static void insertContinue(LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        List<BlockNode> predecessors = loopEnd.getPredecessors();
        if (predecessors.size() <= 1) {
            return;
        }
        Set<BlockNode> loopExitNodes = loop.getExitNodes();
        for (BlockNode pred : predecessors) {
            if (!LoopRegionMaker.canInsertContinue(pred, predecessors, loopEnd, loopExitNodes)) continue;
            InsnNode cont = new InsnNode(InsnType.CONTINUE, 0);
            pred.getInstructions().add(cont);
        }
    }

    private static boolean canInsertContinue(BlockNode pred, List<BlockNode> predecessors, BlockNode loopEnd, Set<BlockNode> loopExitNodes) {
        if (!pred.contains(AFlag.SYNTHETIC) || BlockUtils.checkLastInsnType(pred, InsnType.CONTINUE)) {
            return false;
        }
        List<BlockNode> preds = pred.getPredecessors();
        if (preds.isEmpty()) {
            return false;
        }
        BlockNode codePred = preds.get(0);
        if (codePred.contains(AFlag.ADDED_TO_REGION)) {
            return false;
        }
        if (loopEnd.isDominator(codePred) || loopExitNodes.contains(codePred)) {
            return false;
        }
        if (LoopRegionMaker.isDominatedOnBlocks(codePred, predecessors)) {
            return false;
        }
        boolean gotoExit = false;
        for (BlockNode exit : loopExitNodes) {
            if (!BlockUtils.isPathExists(codePred, exit)) continue;
            gotoExit = true;
            break;
        }
        return gotoExit;
    }

    private static boolean isDominatedOnBlocks(BlockNode dom, List<BlockNode> blocks) {
        for (BlockNode node : blocks) {
            if (node.isDominator(dom)) continue;
            return false;
        }
        return true;
    }
}

