/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.data.impl;

import jadx.api.data.CommentStyle;
import jadx.api.data.ICodeComment;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JadxCodeComment
implements ICodeComment {
    private IJavaNodeRef nodeRef;
    @Nullable
    private IJavaCodeRef codeRef;
    private String comment;
    private CommentStyle style = CommentStyle.LINE;

    public JadxCodeComment(IJavaNodeRef nodeRef, String comment) {
        this(nodeRef, null, comment);
    }

    public JadxCodeComment(IJavaNodeRef nodeRef, String comment, CommentStyle style) {
        this(nodeRef, null, comment, style);
    }

    public JadxCodeComment(IJavaNodeRef nodeRef, @Nullable IJavaCodeRef codeRef, String comment) {
        this(nodeRef, codeRef, comment, CommentStyle.LINE);
    }

    public JadxCodeComment(IJavaNodeRef nodeRef, @Nullable IJavaCodeRef codeRef, String comment, CommentStyle style) {
        this.nodeRef = nodeRef;
        this.codeRef = codeRef;
        this.comment = comment;
        this.style = style;
    }

    public JadxCodeComment() {
    }

    @Override
    public IJavaNodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void setNodeRef(IJavaNodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    @Override
    @Nullable
    public IJavaCodeRef getCodeRef() {
        return this.codeRef;
    }

    public void setCodeRef(@Nullable IJavaCodeRef codeRef) {
        this.codeRef = codeRef;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public CommentStyle getStyle() {
        return this.style;
    }

    public void setStyle(CommentStyle style) {
        this.style = style;
    }

    @Override
    public int compareTo(@NotNull ICodeComment other) {
        int cmpNodeRef = this.getNodeRef().compareTo(other.getNodeRef());
        if (cmpNodeRef != 0) {
            return cmpNodeRef;
        }
        if (this.getCodeRef() != null && other.getCodeRef() != null) {
            return this.getCodeRef().compareTo(other.getCodeRef());
        }
        return this.getComment().compareTo(other.getComment());
    }

    public String toString() {
        return "JadxCodeComment{" + this.nodeRef + ", ref=" + this.codeRef + ", comment='" + this.comment + "', style=" + this.style + "}";
    }
}

