/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.ICodeCache;
import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.api.args.GeneratedRenamesMappingFileMode;
import jadx.api.args.IntegerFormat;
import jadx.api.args.ResourceNameSource;
import jadx.api.args.UseSourceNameAsClassNameAlias;
import jadx.api.args.UserRenamesMappingsMode;
import jadx.api.data.ICodeData;
import jadx.api.deobf.IAliasProvider;
import jadx.api.deobf.IRenameCondition;
import jadx.api.impl.AnnotatedCodeWriter;
import jadx.api.impl.InMemoryCodeCache;
import jadx.api.plugins.loader.JadxBasePluginLoader;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.api.security.IJadxSecurity;
import jadx.api.security.JadxSecurityFlag;
import jadx.api.security.impl.JadxSecurity;
import jadx.api.usage.IUsageInfoCache;
import jadx.api.usage.impl.InMemoryUsageInfoCache;
import jadx.core.deobf.DeobfAliasProvider;
import jadx.core.deobf.conditions.DeobfWhitelist;
import jadx.core.deobf.conditions.JadxRenameConditions;
import jadx.core.plugins.PluginContext;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.plugins.files.TempFilesGetter;
import jadx.core.utils.files.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxArgs
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JadxArgs.class);
    public static final int DEFAULT_THREADS_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    public static final String DEFAULT_NEW_LINE_STR = System.lineSeparator();
    public static final String DEFAULT_INDENT_STR = "    ";
    public static final String DEFAULT_OUT_DIR = "jadx-output";
    public static final String DEFAULT_SRC_DIR = "sources";
    public static final String DEFAULT_RES_DIR = "resources";
    private List<File> inputFiles = new ArrayList<File>(1);
    private File outDir;
    private File outDirSrc;
    private File outDirRes;
    private ICodeCache codeCache = new InMemoryCodeCache();
    private IUsageInfoCache usageInfoCache = new InMemoryUsageInfoCache();
    private Function<JadxArgs, ICodeWriter> codeWriterProvider = AnnotatedCodeWriter::new;
    private int threadsCount = DEFAULT_THREADS_COUNT;
    private boolean cfgOutput = false;
    private boolean rawCFGOutput = false;
    private boolean showInconsistentCode = false;
    private boolean useImports = true;
    private boolean debugInfo = true;
    private boolean insertDebugLines = false;
    private boolean extractFinally = true;
    private boolean inlineAnonymousClasses = true;
    private boolean inlineMethods = true;
    private boolean allowInlineKotlinLambda = true;
    private boolean moveInnerClasses = true;
    private boolean skipResources = false;
    private boolean skipSources = false;
    private Predicate<String> classFilter = null;
    private boolean includeDependencies = false;
    private Path userRenamesMappingsPath = null;
    private UserRenamesMappingsMode userRenamesMappingsMode = UserRenamesMappingsMode.getDefault();
    private boolean deobfuscationOn = false;
    private UseSourceNameAsClassNameAlias useSourceNameAsClassNameAlias = UseSourceNameAsClassNameAlias.getDefault();
    private File generatedRenamesMappingFile = null;
    private GeneratedRenamesMappingFileMode generatedRenamesMappingFileMode = GeneratedRenamesMappingFileMode.getDefault();
    private ResourceNameSource resourceNameSource = ResourceNameSource.AUTO;
    private int deobfuscationMinLength = 0;
    private int deobfuscationMaxLength = Integer.MAX_VALUE;
    private List<String> deobfuscationWhitelist = DeobfWhitelist.DEFAULT_LIST;
    private IAliasProvider aliasProvider = new DeobfAliasProvider();
    private IRenameCondition renameCondition = JadxRenameConditions.buildDefault();
    private boolean escapeUnicode = false;
    private boolean replaceConsts = true;
    private boolean respectBytecodeAccModifiers = false;
    private boolean exportAsGradleProject = false;
    private boolean restoreSwitchOverString = true;
    private boolean skipXmlPrettyPrint = false;
    private boolean fsCaseSensitive;
    private Set<RenameEnum> renameFlags = EnumSet.allOf(RenameEnum.class);
    private OutputFormatEnum outputFormat = OutputFormatEnum.JAVA;
    private DecompilationMode decompilationMode = DecompilationMode.AUTO;
    private ICodeData codeData;
    private String codeNewLineStr = DEFAULT_NEW_LINE_STR;
    private String codeIndentStr = "    ";
    private CommentsLevel commentsLevel = CommentsLevel.INFO;
    private IntegerFormat integerFormat = IntegerFormat.AUTO;
    private boolean useDxInput = false;
    private UseKotlinMethodsForVarNames useKotlinMethodsForVarNames = UseKotlinMethodsForVarNames.APPLY;
    private IJadxFilesGetter filesGetter = TempFilesGetter.INSTANCE;
    private IJadxSecurity security = new JadxSecurity(JadxSecurityFlag.all());
    private boolean skipFilesSave = false;
    private boolean runDebugChecks = false;
    private Map<String, String> pluginOptions = new HashMap<String, String>();
    private Set<String> disabledPlugins = new HashSet<String>();
    private JadxPluginLoader pluginLoader = new JadxBasePluginLoader();
    private boolean loadJadxClsSetFile = true;

    public void setRootDir(File rootDir) {
        this.setOutDir(rootDir);
        this.setOutDirSrc(new File(rootDir, DEFAULT_SRC_DIR));
        this.setOutDirRes(new File(rootDir, DEFAULT_RES_DIR));
    }

    @Override
    public void close() {
        try {
            this.inputFiles = null;
            if (this.codeCache != null) {
                this.codeCache.close();
            }
            if (this.usageInfoCache != null) {
                this.usageInfoCache.close();
            }
            if (this.pluginLoader != null) {
                this.pluginLoader.close();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close JadxArgs", (Throwable)e);
        }
        finally {
            this.codeCache = null;
            this.usageInfoCache = null;
        }
    }

    public List<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFile(File inputFile) {
        this.inputFiles = Collections.singletonList(inputFile);
    }

    public void setInputFiles(List<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public File getOutDirSrc() {
        return this.outDirSrc;
    }

    public void setOutDirSrc(File outDirSrc) {
        this.outDirSrc = outDirSrc;
    }

    public File getOutDirRes() {
        return this.outDirRes;
    }

    public void setOutDirRes(File outDirRes) {
        this.outDirRes = outDirRes;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = Math.max(1, threadsCount);
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public boolean isRawCFGOutput() {
        return this.rawCFGOutput;
    }

    public void setRawCFGOutput(boolean rawCFGOutput) {
        this.rawCFGOutput = rawCFGOutput;
    }

    public boolean isFallbackMode() {
        return this.decompilationMode == DecompilationMode.FALLBACK;
    }

    @Deprecated
    public void setFallbackMode(boolean fallbackMode) {
        if (fallbackMode) {
            this.decompilationMode = DecompilationMode.FALLBACK;
        }
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public boolean isDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(boolean debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean isInsertDebugLines() {
        return this.insertDebugLines;
    }

    public void setInsertDebugLines(boolean insertDebugLines) {
        this.insertDebugLines = insertDebugLines;
    }

    public boolean isInlineAnonymousClasses() {
        return this.inlineAnonymousClasses;
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.inlineAnonymousClasses = inlineAnonymousClasses;
    }

    public boolean isInlineMethods() {
        return this.inlineMethods;
    }

    public void setInlineMethods(boolean inlineMethods) {
        this.inlineMethods = inlineMethods;
    }

    public boolean isAllowInlineKotlinLambda() {
        return this.allowInlineKotlinLambda;
    }

    public void setAllowInlineKotlinLambda(boolean allowInlineKotlinLambda) {
        this.allowInlineKotlinLambda = allowInlineKotlinLambda;
    }

    public boolean isMoveInnerClasses() {
        return this.moveInnerClasses;
    }

    public void setMoveInnerClasses(boolean moveInnerClasses) {
        this.moveInnerClasses = moveInnerClasses;
    }

    public boolean isExtractFinally() {
        return this.extractFinally;
    }

    public void setExtractFinally(boolean extractFinally) {
        this.extractFinally = extractFinally;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public boolean isIncludeDependencies() {
        return this.includeDependencies;
    }

    public Predicate<String> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Predicate<String> classFilter) {
        this.classFilter = classFilter;
    }

    public Path getUserRenamesMappingsPath() {
        return this.userRenamesMappingsPath;
    }

    public void setUserRenamesMappingsPath(Path path) {
        this.userRenamesMappingsPath = path;
    }

    public UserRenamesMappingsMode getUserRenamesMappingsMode() {
        return this.userRenamesMappingsMode;
    }

    public void setUserRenamesMappingsMode(UserRenamesMappingsMode mode) {
        this.userRenamesMappingsMode = mode;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    public boolean isDeobfuscationForceSave() {
        return this.generatedRenamesMappingFileMode == GeneratedRenamesMappingFileMode.OVERWRITE;
    }

    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        if (deobfuscationForceSave) {
            this.generatedRenamesMappingFileMode = GeneratedRenamesMappingFileMode.OVERWRITE;
        }
    }

    public GeneratedRenamesMappingFileMode getGeneratedRenamesMappingFileMode() {
        return this.generatedRenamesMappingFileMode;
    }

    public void setGeneratedRenamesMappingFileMode(GeneratedRenamesMappingFileMode mode) {
        this.generatedRenamesMappingFileMode = mode;
    }

    public UseSourceNameAsClassNameAlias getUseSourceNameAsClassNameAlias() {
        return this.useSourceNameAsClassNameAlias;
    }

    public void setUseSourceNameAsClassNameAlias(UseSourceNameAsClassNameAlias useSourceNameAsClassNameAlias) {
        this.useSourceNameAsClassNameAlias = useSourceNameAsClassNameAlias;
    }

    @Deprecated
    public boolean isUseSourceNameAsClassAlias() {
        return this.getUseSourceNameAsClassNameAlias().toBoolean();
    }

    @Deprecated
    public void setUseSourceNameAsClassAlias(boolean useSourceNameAsClassAlias) {
        UseSourceNameAsClassNameAlias useSourceNameAsClassNameAlias = UseSourceNameAsClassNameAlias.create(useSourceNameAsClassAlias);
        this.setUseSourceNameAsClassNameAlias(useSourceNameAsClassNameAlias);
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public List<String> getDeobfuscationWhitelist() {
        return this.deobfuscationWhitelist;
    }

    public void setDeobfuscationWhitelist(List<String> deobfuscationWhitelist) {
        this.deobfuscationWhitelist = deobfuscationWhitelist;
    }

    public File getGeneratedRenamesMappingFile() {
        return this.generatedRenamesMappingFile;
    }

    public void setGeneratedRenamesMappingFile(File file) {
        this.generatedRenamesMappingFile = file;
    }

    public ResourceNameSource getResourceNameSource() {
        return this.resourceNameSource;
    }

    public void setResourceNameSource(ResourceNameSource resourceNameSource) {
        this.resourceNameSource = resourceNameSource;
    }

    public IAliasProvider getAliasProvider() {
        return this.aliasProvider;
    }

    public void setAliasProvider(IAliasProvider aliasProvider) {
        this.aliasProvider = aliasProvider;
    }

    public IRenameCondition getRenameCondition() {
        return this.renameCondition;
    }

    public void setRenameCondition(IRenameCondition renameCondition) {
        this.renameCondition = renameCondition;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public boolean isRespectBytecodeAccModifiers() {
        return this.respectBytecodeAccModifiers;
    }

    public void setRespectBytecodeAccModifiers(boolean respectBytecodeAccModifiers) {
        this.respectBytecodeAccModifiers = respectBytecodeAccModifiers;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public boolean isRestoreSwitchOverString() {
        return this.restoreSwitchOverString;
    }

    public void setRestoreSwitchOverString(boolean restoreSwitchOverString) {
        this.restoreSwitchOverString = restoreSwitchOverString;
    }

    public boolean isSkipXmlPrettyPrint() {
        return this.skipXmlPrettyPrint;
    }

    public void setSkipXmlPrettyPrint(boolean skipXmlPrettyPrint) {
        this.skipXmlPrettyPrint = skipXmlPrettyPrint;
    }

    public boolean isFsCaseSensitive() {
        return this.fsCaseSensitive;
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.fsCaseSensitive = fsCaseSensitive;
    }

    public boolean isRenameCaseSensitive() {
        return this.renameFlags.contains((Object)RenameEnum.CASE);
    }

    public void setRenameCaseSensitive(boolean renameCaseSensitive) {
        this.updateRenameFlag(renameCaseSensitive, RenameEnum.CASE);
    }

    public boolean isRenameValid() {
        return this.renameFlags.contains((Object)RenameEnum.VALID);
    }

    public void setRenameValid(boolean renameValid) {
        this.updateRenameFlag(renameValid, RenameEnum.VALID);
    }

    public boolean isRenamePrintable() {
        return this.renameFlags.contains((Object)RenameEnum.PRINTABLE);
    }

    public void setRenamePrintable(boolean renamePrintable) {
        this.updateRenameFlag(renamePrintable, RenameEnum.PRINTABLE);
    }

    private void updateRenameFlag(boolean enabled, RenameEnum flag) {
        if (enabled) {
            this.renameFlags.add(flag);
        } else {
            this.renameFlags.remove((Object)flag);
        }
    }

    public void setRenameFlags(Set<RenameEnum> renameFlags) {
        this.renameFlags = renameFlags;
    }

    public Set<RenameEnum> getRenameFlags() {
        return this.renameFlags;
    }

    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    public boolean isJsonOutput() {
        return this.outputFormat == OutputFormatEnum.JSON;
    }

    public void setOutputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public DecompilationMode getDecompilationMode() {
        return this.decompilationMode;
    }

    public void setDecompilationMode(DecompilationMode decompilationMode) {
        this.decompilationMode = decompilationMode;
    }

    public ICodeCache getCodeCache() {
        return this.codeCache;
    }

    public void setCodeCache(ICodeCache codeCache) {
        this.codeCache = codeCache;
    }

    public Function<JadxArgs, ICodeWriter> getCodeWriterProvider() {
        return this.codeWriterProvider;
    }

    public void setCodeWriterProvider(Function<JadxArgs, ICodeWriter> codeWriterProvider) {
        this.codeWriterProvider = codeWriterProvider;
    }

    public IUsageInfoCache getUsageInfoCache() {
        return this.usageInfoCache;
    }

    public void setUsageInfoCache(IUsageInfoCache usageInfoCache) {
        this.usageInfoCache = usageInfoCache;
    }

    public ICodeData getCodeData() {
        return this.codeData;
    }

    public void setCodeData(ICodeData codeData) {
        this.codeData = codeData;
    }

    public String getCodeIndentStr() {
        return this.codeIndentStr;
    }

    public void setCodeIndentStr(String codeIndentStr) {
        this.codeIndentStr = codeIndentStr;
    }

    public String getCodeNewLineStr() {
        return this.codeNewLineStr;
    }

    public void setCodeNewLineStr(String codeNewLineStr) {
        this.codeNewLineStr = codeNewLineStr;
    }

    public CommentsLevel getCommentsLevel() {
        return this.commentsLevel;
    }

    public void setCommentsLevel(CommentsLevel commentsLevel) {
        this.commentsLevel = commentsLevel;
    }

    public IntegerFormat getIntegerFormat() {
        return this.integerFormat;
    }

    public void setIntegerFormat(IntegerFormat format) {
        this.integerFormat = format;
    }

    public boolean isUseDxInput() {
        return this.useDxInput;
    }

    public void setUseDxInput(boolean useDxInput) {
        this.useDxInput = useDxInput;
    }

    public UseKotlinMethodsForVarNames getUseKotlinMethodsForVarNames() {
        return this.useKotlinMethodsForVarNames;
    }

    public void setUseKotlinMethodsForVarNames(UseKotlinMethodsForVarNames useKotlinMethodsForVarNames) {
        this.useKotlinMethodsForVarNames = useKotlinMethodsForVarNames;
    }

    public IJadxFilesGetter getFilesGetter() {
        return this.filesGetter;
    }

    public void setFilesGetter(IJadxFilesGetter filesGetter) {
        this.filesGetter = filesGetter;
    }

    public IJadxSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(IJadxSecurity security) {
        this.security = security;
    }

    public boolean isSkipFilesSave() {
        return this.skipFilesSave;
    }

    public void setSkipFilesSave(boolean skipFilesSave) {
        this.skipFilesSave = skipFilesSave;
    }

    public boolean isRunDebugChecks() {
        return this.runDebugChecks;
    }

    public void setRunDebugChecks(boolean runDebugChecks) {
        this.runDebugChecks = runDebugChecks;
    }

    public Map<String, String> getPluginOptions() {
        return this.pluginOptions;
    }

    public void setPluginOptions(Map<String, String> pluginOptions) {
        this.pluginOptions = pluginOptions;
    }

    public Set<String> getDisabledPlugins() {
        return this.disabledPlugins;
    }

    public void setDisabledPlugins(Set<String> disabledPlugins) {
        this.disabledPlugins = disabledPlugins;
    }

    public JadxPluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public void setPluginLoader(JadxPluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    public boolean isLoadJadxClsSetFile() {
        return this.loadJadxClsSetFile;
    }

    public void setLoadJadxClsSetFile(boolean loadJadxClsSetFile) {
        this.loadJadxClsSetFile = loadJadxClsSetFile;
    }

    public String makeCodeArgsHash(@Nullable JadxDecompiler decompiler) {
        String argStr = "args:" + this.decompilationMode + this.useImports + this.showInconsistentCode + this.inlineAnonymousClasses + this.inlineMethods + this.moveInnerClasses + this.allowInlineKotlinLambda + this.deobfuscationOn + this.deobfuscationMinLength + this.deobfuscationMaxLength + this.deobfuscationWhitelist + this.useSourceNameAsClassNameAlias + this.resourceNameSource + this.useKotlinMethodsForVarNames + this.insertDebugLines + this.extractFinally + this.debugInfo + this.escapeUnicode + this.replaceConsts + this.restoreSwitchOverString + this.respectBytecodeAccModifiers + this.fsCaseSensitive + this.renameFlags + this.commentsLevel + this.useDxInput + this.integerFormat + "|" + JadxArgs.buildPluginsHash(decompiler);
        return FileUtils.md5Sum(argStr);
    }

    private static String buildPluginsHash(@Nullable JadxDecompiler decompiler) {
        if (decompiler == null) {
            return "";
        }
        return decompiler.getPluginManager().getResolvedPluginContexts().stream().map(PluginContext::getInputsHash).collect(Collectors.joining(":"));
    }

    public String toString() {
        return "JadxArgs{inputFiles=" + this.inputFiles + ", outDir=" + this.outDir + ", outDirSrc=" + this.outDirSrc + ", outDirRes=" + this.outDirRes + ", threadsCount=" + this.threadsCount + ", decompilationMode=" + this.decompilationMode + ", showInconsistentCode=" + this.showInconsistentCode + ", useImports=" + this.useImports + ", skipResources=" + this.skipResources + ", skipSources=" + this.skipSources + ", includeDependencies=" + this.includeDependencies + ", userRenamesMappingsPath=" + this.userRenamesMappingsPath + ", userRenamesMappingsMode=" + this.userRenamesMappingsMode + ", deobfuscationOn=" + this.deobfuscationOn + ", generatedRenamesMappingFile=" + this.generatedRenamesMappingFile + ", generatedRenamesMappingFileMode=" + this.generatedRenamesMappingFileMode + ", resourceNameSource=" + this.resourceNameSource + ", useSourceNameAsClassNameAlias=" + this.useSourceNameAsClassNameAlias + ", useKotlinMethodsForVarNames=" + this.useKotlinMethodsForVarNames + ", insertDebugLines=" + this.insertDebugLines + ", extractFinally=" + this.extractFinally + ", deobfuscationMinLength=" + this.deobfuscationMinLength + ", deobfuscationMaxLength=" + this.deobfuscationMaxLength + ", deobfuscationWhitelist=" + this.deobfuscationWhitelist + ", escapeUnicode=" + this.escapeUnicode + ", replaceConsts=" + this.replaceConsts + ", restoreSwitchOverString=" + this.restoreSwitchOverString + ", respectBytecodeAccModifiers=" + this.respectBytecodeAccModifiers + ", exportAsGradleProject=" + this.exportAsGradleProject + ", skipXmlPrettyPrint=" + this.skipXmlPrettyPrint + ", fsCaseSensitive=" + this.fsCaseSensitive + ", renameFlags=" + this.renameFlags + ", outputFormat=" + this.outputFormat + ", commentsLevel=" + this.commentsLevel + ", codeCache=" + this.codeCache + ", codeWriter=" + this.codeWriterProvider.apply(this).getClass().getSimpleName() + ", useDxInput=" + this.useDxInput + ", pluginOptions=" + this.pluginOptions + ", cfgOutput=" + this.cfgOutput + ", rawCFGOutput=" + this.rawCFGOutput + "}";
    }

    public static enum UseKotlinMethodsForVarNames {
        DISABLE,
        APPLY,
        APPLY_AND_HIDE;

    }

    public static enum OutputFormatEnum {
        JAVA,
        JSON;

    }

    public static enum RenameEnum {
        CASE,
        VALID,
        PRINTABLE;

    }
}

